/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class ElasticsearchInternalServiceSettings
extends InternalServiceSettings {
    public static final String NAME = "text_embedding_internal_service_settings";
    private static final int FAILED_INT_PARSE_VALUE = -1;

    public static ElasticsearchInternalServiceSettings fromMap(Map<String, Object> map, ValidationException validationException) {
        Integer numAllocations = ServiceUtils.extractRequiredPositiveInteger(map, "num_allocations", "service_settings", validationException);
        Integer numThreads = ServiceUtils.extractRequiredPositiveInteger(map, "num_threads", "service_settings", validationException);
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        return new ElasticsearchInternalServiceSettings(Objects.requireNonNullElse(numAllocations, -1), Objects.requireNonNullElse(numThreads, -1), modelId);
    }

    public ElasticsearchInternalServiceSettings(int numAllocations, int numThreads, String modelVariant) {
        super(numAllocations, numThreads, modelVariant);
    }

    public ElasticsearchInternalServiceSettings(StreamInput in) throws IOException {
        super(in.readVInt(), in.readVInt(), in.readString());
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }
}

