/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.inference.results.ErrorChunkedInferenceResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlChunkedTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextSimilarityInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationConfigUpdate;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandEmbeddingModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalTextEmbeddingServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandRerankModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallModel;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class ElasticsearchInternalService
implements InferenceService {
    public static final String NAME = "elasticsearch";
    static final String MULTILINGUAL_E5_SMALL_MODEL_ID = ".multilingual-e5-small";
    static final String MULTILINGUAL_E5_SMALL_MODEL_ID_LINUX_X86 = ".multilingual-e5-small_linux-x86_64";
    public static final Set<String> MULTILINGUAL_E5_SMALL_VALID_IDS = Set.of(".multilingual-e5-small", ".multilingual-e5-small_linux-x86_64");
    private final OriginSettingClient client;
    private static final Logger logger = LogManager.getLogger(ElasticsearchInternalService.class);

    public ElasticsearchInternalService(InferenceServiceExtension.InferenceServiceFactoryContext context) {
        this.client = new OriginSettingClient(context.client(), "inference");
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<Model> modelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMap(config, "task_settings");
            String modelId = (String)serviceSettingsMap.get("model_id");
            if (modelId == null) {
                throw new IllegalArgumentException("Error parsing request config, model id is missing");
            }
            if (MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
                this.e5Case(inferenceEntityId, taskType, config, platformArchitectures, serviceSettingsMap, modelListener);
            } else {
                ServiceUtils.throwIfNotEmptyMap(config, this.name());
                this.customElandCase(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, modelListener);
            }
        }
        catch (Exception e) {
            modelListener.onFailure(e);
        }
    }

    private void customElandCase(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettingsMap, Map<String, Object> taskSettingsMap, ActionListener<Model> modelListener) {
        String modelId = (String)serviceSettingsMap.get("model_id");
        GetTrainedModelsAction.Request request = new GetTrainedModelsAction.Request(modelId);
        ActionListener getModelsListener = modelListener.delegateFailureAndWrap((delegate, response) -> {
            if (response.getResources().count() < 1L) {
                throw new IllegalArgumentException("Error parsing request config, model id does not match any models available on this platform. Was [" + modelId + "]. You may need to load it into the cluster using eland.");
            }
            CustomElandModel model = ElasticsearchInternalService.createCustomElandModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, this.name());
            delegate.onResponse((Object)model);
        });
        this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)request, getModelsListener);
    }

    private static CustomElandModel createCustomElandModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new CustomElandEmbeddingModel(inferenceEntityId, taskType, NAME, serviceSettings, context);
            case TaskType.RERANK -> new CustomElandRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, context);
            default -> throw new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    private void e5Case(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, Map<String, Object> serviceSettingsMap, ActionListener<Model> modelListener) {
        InternalServiceSettings.Builder e5ServiceSettings = MultilingualE5SmallInternalServiceSettings.fromMap(serviceSettingsMap);
        if (e5ServiceSettings.getModelId() == null) {
            e5ServiceSettings.setModelId(ElasticsearchInternalService.selectDefaultModelVariantBasedOnClusterArchitecture(platformArchitectures));
        }
        if (ElasticsearchInternalService.modelVariantDoesNotMatchArchitecturesAndIsNotPlatformAgnostic(platformArchitectures, e5ServiceSettings)) {
            throw new IllegalArgumentException("Error parsing request config, model id does not match any models available on this platform. Was [" + e5ServiceSettings.getModelId() + "]");
        }
        ServiceUtils.throwIfNotEmptyMap(config, this.name());
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
        modelListener.onResponse((Object)new MultilingualE5SmallModel(inferenceEntityId, taskType, NAME, (MultilingualE5SmallInternalServiceSettings)e5ServiceSettings.build()));
    }

    private static boolean modelVariantDoesNotMatchArchitecturesAndIsNotPlatformAgnostic(Set<String> platformArchitectures, InternalServiceSettings.Builder e5ServiceSettings) {
        return !e5ServiceSettings.getModelId().equals(ElasticsearchInternalService.selectDefaultModelVariantBasedOnClusterArchitecture(platformArchitectures)) && !e5ServiceSettings.getModelId().equals(MULTILINGUAL_E5_SMALL_MODEL_ID);
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        return this.parsePersistedConfig(inferenceEntityId, taskType, config);
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMap(config, "task_settings");
        String modelId = (String)serviceSettingsMap.get("model_id");
        if (modelId == null) {
            throw new IllegalArgumentException("Error parsing request config, model id is missing");
        }
        if (MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
            return new MultilingualE5SmallModel(inferenceEntityId, taskType, NAME, (MultilingualE5SmallInternalServiceSettings)MultilingualE5SmallInternalServiceSettings.fromMap(serviceSettingsMap).build());
        }
        return ElasticsearchInternalService.createCustomElandModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, ConfigurationParseContext.PERSISTENT);
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        CustomElandEmbeddingModel elandModel;
        if (model instanceof CustomElandEmbeddingModel && (elandModel = (CustomElandEmbeddingModel)model).getTaskType() == TaskType.TEXT_EMBEDDING) {
            CustomElandEmbeddingModel temporaryModelWithModelId = new CustomElandEmbeddingModel(elandModel.getModelId(), elandModel.getTaskType(), elandModel.getConfigurations().getService(), elandModel.getServiceSettings());
            ServiceUtils.getEmbeddingSize(temporaryModelWithModelId, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)ElasticsearchInternalService.updateModelWithEmbeddingDetails(elandModel, size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private static CustomElandEmbeddingModel updateModelWithEmbeddingDetails(CustomElandEmbeddingModel model, int embeddingSize) {
        CustomElandInternalTextEmbeddingServiceSettings serviceSettings = new CustomElandInternalTextEmbeddingServiceSettings(model.getServiceSettings().getElasticsearchInternalServiceSettings().getNumAllocations(), model.getServiceSettings().getElasticsearchInternalServiceSettings().getNumThreads(), model.getServiceSettings().getElasticsearchInternalServiceSettings().getModelId(), embeddingSize, model.getServiceSettings().similarity(), model.getServiceSettings().elementType());
        return new CustomElandEmbeddingModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), serviceSettings);
    }

    public void infer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        TaskType taskType = model.getConfigurations().getTaskType();
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            this.inferTextEmbedding(model, input, inputType, timeout, listener);
        } else if (TaskType.RERANK.equals((Object)taskType)) {
            this.inferRerank(model, query, input, inputType, timeout, taskSettings, listener);
        } else {
            throw new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    public void inferTextEmbedding(Model model, List<String> inputs, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.getConfigurations().getInferenceEntityId(), (InferenceConfigUpdate)TextEmbeddingConfigUpdate.EMPTY_INSTANCE, inputs, inputType, timeout, false);
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse((Object)InferenceTextEmbeddingFloatResults.of((List)inferenceResult.getInferenceResults()))));
    }

    public void inferRerank(Model model, String query, List<String> inputs, InputType inputType, TimeValue timeout, Map<String, Object> requestTaskSettings, ActionListener<InferenceServiceResults> listener) {
        CustomElandRerankTaskSettings requestSettings;
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.getConfigurations().getInferenceEntityId(), (InferenceConfigUpdate)new TextSimilarityConfigUpdate(query), inputs, inputType, timeout, false);
        CustomElandRerankTaskSettings modelSettings = (CustomElandRerankTaskSettings)model.getTaskSettings();
        Boolean returnDocs = CustomElandRerankTaskSettings.of(modelSettings, requestSettings = CustomElandRerankTaskSettings.fromMap(requestTaskSettings)).returnDocuments();
        Function<Integer, String> inputSupplier = returnDocs == Boolean.TRUE ? inputs::get : i -> null;
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse((Object)this.textSimilarityResultsToRankedDocs(inferenceResult.getInferenceResults(), inputSupplier))));
    }

    public void chunkedInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        this.chunkedInfer(model, null, input, taskSettings, inputType, chunkingOptions, timeout, listener);
    }

    public void chunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        if (!TaskType.TEXT_EMBEDDING.isAnyOrSame(model.getTaskType())) {
            listener.onFailure((Exception)new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)model.getTaskType(), (String)NAME), RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        TokenizationConfigUpdate configUpdate = chunkingOptions != null ? new TokenizationConfigUpdate(chunkingOptions.windowSize(), chunkingOptions.span()) : new TokenizationConfigUpdate(null, null);
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.getConfigurations().getInferenceEntityId(), (InferenceConfigUpdate)configUpdate, input, inputType, timeout, true);
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse(ElasticsearchInternalService.translateToChunkedResults(inferenceResult.getInferenceResults()))));
    }

    private static List<ChunkedInferenceServiceResults> translateToChunkedResults(List<InferenceResults> inferenceResults) {
        ArrayList<ChunkedInferenceServiceResults> translated = new ArrayList<ChunkedInferenceServiceResults>();
        for (InferenceResults inferenceResult : inferenceResults) {
            translated.add(ElasticsearchInternalService.translateToChunkedResult(inferenceResult));
        }
        return translated;
    }

    private static ChunkedInferenceServiceResults translateToChunkedResult(InferenceResults inferenceResult) {
        if (inferenceResult instanceof MlChunkedTextEmbeddingFloatResults) {
            MlChunkedTextEmbeddingFloatResults mlChunkedResult = (MlChunkedTextEmbeddingFloatResults)inferenceResult;
            return InferenceChunkedTextEmbeddingFloatResults.ofMlResults((MlChunkedTextEmbeddingFloatResults)mlChunkedResult);
        }
        if (inferenceResult instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResult;
            return new ErrorChunkedInferenceResults(error.getException());
        }
        throw ResultUtils.createInvalidChunkedResultException((String)"chunked_text_embedding_result", (String)inferenceResult.getWriteableName());
    }

    public void start(Model model, ActionListener<Boolean> listener) {
        if (!(model instanceof ElasticsearchModel)) {
            listener.onFailure((Exception)ElasticsearchInternalService.notTextEmbeddingModelException(model));
            return;
        }
        if (model.getTaskType() != TaskType.TEXT_EMBEDDING && model.getTaskType() != TaskType.RERANK) {
            listener.onFailure((Exception)new IllegalStateException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)model.getConfigurations().getTaskType(), (String)NAME)));
            return;
        }
        StartTrainedModelDeploymentAction.Request startRequest = ((ElasticsearchModel)model).getStartTrainedModelDeploymentActionRequest();
        ActionListener<CreateTrainedModelAssignmentAction.Response> responseListener = ((ElasticsearchModel)model).getCreateTrainedModelAssignmentActionListener(model, listener);
        this.client.execute((ActionType)StartTrainedModelDeploymentAction.INSTANCE, (ActionRequest)startRequest, responseListener);
    }

    public void stop(String inferenceEntityId, ActionListener<Boolean> listener) {
        StopTrainedModelDeploymentAction.Request request = new StopTrainedModelDeploymentAction.Request(inferenceEntityId);
        request.setForce(true);
        this.client.execute((ActionType)StopTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((delegatedResponseListener, response) -> delegatedResponseListener.onResponse((Object)Boolean.TRUE)));
    }

    public void putModel(Model model, ActionListener<Boolean> listener) {
        if (!(model instanceof ElasticsearchModel)) {
            listener.onFailure((Exception)ElasticsearchInternalService.notTextEmbeddingModelException(model));
            return;
        }
        if (model instanceof MultilingualE5SmallModel) {
            MultilingualE5SmallModel e5Model = (MultilingualE5SmallModel)model;
            String modelId = e5Model.getServiceSettings().getModelId();
            TrainedModelInput input = new TrainedModelInput(List.of("text_field"));
            TrainedModelConfig config = TrainedModelConfig.builder().setInput(input).setModelId(modelId).validate(true).build();
            PutTrainedModelAction.Request putRequest = new PutTrainedModelAction.Request(config, false, true);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"inference", (ActionType)PutTrainedModelAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)Boolean.TRUE), e -> {
                ElasticsearchStatusException esException;
                if (e instanceof ElasticsearchStatusException && (esException = (ElasticsearchStatusException)e).getMessage().contains("the model id is the same as the deployment id of a current model deployment")) {
                    listener.onResponse((Object)Boolean.TRUE);
                } else {
                    listener.onFailure(e);
                }
            }));
        } else if (model instanceof CustomElandModel) {
            logger.info("Custom eland model detected, model must have been already loaded into the cluster with eland.");
            listener.onResponse((Object)Boolean.TRUE);
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("Can not download model automatically for [" + model.getConfigurations().getInferenceEntityId() + "] you may need to download it through the trained models API or with eland."));
            return;
        }
    }

    public void isModelDownloaded(Model model, ActionListener<Boolean> listener) {
        ActionListener getModelsResponseListener = listener.delegateFailure((delegate, response) -> {
            if (response.getResources().count() < 1L) {
                delegate.onResponse((Object)Boolean.FALSE);
            } else {
                delegate.onResponse((Object)Boolean.TRUE);
            }
        });
        if (!(model instanceof ElasticsearchModel)) {
            listener.onFailure((Exception)ElasticsearchInternalService.notTextEmbeddingModelException(model));
        } else {
            ServiceSettings serviceSettings = model.getServiceSettings();
            if (serviceSettings instanceof InternalServiceSettings) {
                InternalServiceSettings internalServiceSettings = (InternalServiceSettings)serviceSettings;
                String modelId = internalServiceSettings.getModelId();
                GetTrainedModelsAction.Request getRequest = new GetTrainedModelsAction.Request(modelId);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"inference", (ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)getModelsResponseListener);
            } else {
                listener.onFailure((Exception)new IllegalArgumentException("Unable to determine supported model for [" + model.getConfigurations().getInferenceEntityId() + "] please verify the request and submit a bug report if necessary."));
            }
        }
    }

    private static IllegalStateException notTextEmbeddingModelException(Model model) {
        return new IllegalStateException("Error starting model, [" + model.getConfigurations().getInferenceEntityId() + "] is not a text embedding model");
    }

    public boolean isInClusterService() {
        return true;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_L2_NORM_SIMILARITY_ADDED;
    }

    public void close() throws IOException {
    }

    public String name() {
        return NAME;
    }

    private static String selectDefaultModelVariantBasedOnClusterArchitecture(Set<String> modelArchitectures) {
        boolean homogenous;
        boolean bl = homogenous = modelArchitectures.size() == 1;
        if (homogenous && modelArchitectures.iterator().next().equals("linux-x86_64")) {
            return MULTILINGUAL_E5_SMALL_MODEL_ID_LINUX_X86;
        }
        return MULTILINGUAL_E5_SMALL_MODEL_ID;
    }

    private RankedDocsResults textSimilarityResultsToRankedDocs(List<? extends InferenceResults> results, Function<Integer, String> inputSupplier) {
        ArrayList<RankedDocsResults.RankedDoc> rankings = new ArrayList<RankedDocsResults.RankedDoc>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            InferenceResults result = results.get(i);
            if (!(result instanceof TextSimilarityInferenceResults)) {
                if (result instanceof ErrorInferenceResults) {
                    ErrorInferenceResults errorResult = (ErrorInferenceResults)result;
                    Exception exception = errorResult.getException();
                    if (exception instanceof ElasticsearchStatusException) {
                        ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
                        throw statusException;
                    }
                    throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)errorResult.getException(), new Object[0]);
                }
                throw new IllegalArgumentException("Received invalid inference result, of type " + result.getClass().getName() + " but expected TextSimilarityInferenceResults.");
            }
            TextSimilarityInferenceResults similarity = (TextSimilarityInferenceResults)result;
            rankings.add(new RankedDocsResults.RankedDoc(i, (float)similarity.score(), inputSupplier.apply(i)));
        }
        Collections.sort(rankings);
        return new RankedDocsResults(rankings);
    }

    public static InferModelAction.Request buildInferenceRequest(String id, InferenceConfigUpdate update, List<String> inputs, InputType inputType, TimeValue timeout, boolean chunk) {
        InferModelAction.Request request = InferModelAction.Request.forTextInput((String)id, (InferenceConfigUpdate)update, inputs, (boolean)true, (TimeValue)timeout);
        request.setPrefixType(InputType.SEARCH == inputType ? TrainedModelPrefixStrings.PrefixType.SEARCH : TrainedModelPrefixStrings.PrefixType.INGEST);
        request.setHighPriority(InputType.SEARCH == inputType);
        request.setChunked(chunk);
        return request;
    }
}

