/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchModel;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class CustomElandModel
extends Model
implements ElasticsearchModel {
    private final InternalServiceSettings internalServiceSettings;

    public CustomElandModel(ModelConfigurations configurations, InternalServiceSettings internalServiceSettings) {
        super(configurations);
        this.internalServiceSettings = Objects.requireNonNull(internalServiceSettings);
    }

    @Override
    public String getModelId() {
        return this.internalServiceSettings.getModelId();
    }

    @Override
    public StartTrainedModelDeploymentAction.Request getStartTrainedModelDeploymentActionRequest() {
        StartTrainedModelDeploymentAction.Request startRequest = new StartTrainedModelDeploymentAction.Request(this.internalServiceSettings.getModelId(), this.getInferenceEntityId());
        startRequest.setNumberOfAllocations(this.internalServiceSettings.getNumAllocations());
        startRequest.setThreadsPerAllocation(this.internalServiceSettings.getNumThreads());
        startRequest.setWaitForState(AllocationStatus.State.STARTED);
        return startRequest;
    }

    @Override
    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the TextEmbeddingService service as the custom eland model [{0}] for this platform cannot be found. Custom models need to be loaded into the cluster with eland before they can be started.", new Object[]{CustomElandModel.this.getModelId()}));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

