/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class CustomElandInternalTextEmbeddingServiceSettings
implements ServiceSettings {
    public static final String NAME = "custom_eland_model_internal_text_embedding_service_settings";
    private final ElasticsearchInternalServiceSettings internalServiceSettings;
    private final Integer dimensions;
    private final SimilarityMeasure similarityMeasure;
    private final DenseVectorFieldMapper.ElementType elementType;

    public static CustomElandInternalTextEmbeddingServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationParseContext.REQUEST -> CustomElandInternalTextEmbeddingServiceSettings.fromRequestMap(map);
            case ConfigurationParseContext.PERSISTENT -> CustomElandInternalTextEmbeddingServiceSettings.fromPersistedMap(map);
        };
    }

    private static CustomElandInternalTextEmbeddingServiceSettings fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        CommonFields commonFields = CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CustomElandInternalTextEmbeddingServiceSettings(commonFields);
    }

    private static CustomElandInternalTextEmbeddingServiceSettings fromPersistedMap(Map<String, Object> map) {
        CommonFields commonFields = CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", new ValidationException());
        return new CustomElandInternalTextEmbeddingServiceSettings(commonFields, dims);
    }

    private static CommonFields commonFieldsFromMap(Map<String, Object> map) {
        return CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map, new ValidationException());
    }

    private static CommonFields commonFieldsFromMap(Map<String, Object> map, ValidationException validationException) {
        ElasticsearchInternalServiceSettings internalSettings = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        DenseVectorFieldMapper.ElementType elementType = ServiceUtils.extractOptionalEnum(map, "element_type", "service_settings", DenseVectorFieldMapper.ElementType::fromString, EnumSet.of(DenseVectorFieldMapper.ElementType.BYTE, DenseVectorFieldMapper.ElementType.FLOAT), validationException);
        return new CommonFields(internalSettings, Objects.requireNonNullElse(similarity, SimilarityMeasure.COSINE), Objects.requireNonNullElse(elementType, DenseVectorFieldMapper.ElementType.FLOAT));
    }

    public CustomElandInternalTextEmbeddingServiceSettings(int numAllocations, int numThreads, String modelId) {
        this(numAllocations, numThreads, modelId, null, SimilarityMeasure.COSINE, DenseVectorFieldMapper.ElementType.FLOAT);
    }

    public CustomElandInternalTextEmbeddingServiceSettings(int numAllocations, int numThreads, String modelId, Integer dimensions, SimilarityMeasure similarityMeasure, DenseVectorFieldMapper.ElementType elementType) {
        this.internalServiceSettings = new ElasticsearchInternalServiceSettings(numAllocations, numThreads, modelId);
        this.dimensions = dimensions;
        this.similarityMeasure = Objects.requireNonNull(similarityMeasure);
        this.elementType = Objects.requireNonNull(elementType);
    }

    public CustomElandInternalTextEmbeddingServiceSettings(StreamInput in) throws IOException {
        this.internalServiceSettings = new ElasticsearchInternalServiceSettings(in);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_ELAND_SETTINGS_ADDED)) {
            this.dimensions = in.readOptionalVInt();
            this.similarityMeasure = (SimilarityMeasure)in.readEnum(SimilarityMeasure.class);
            this.elementType = (DenseVectorFieldMapper.ElementType)in.readEnum(DenseVectorFieldMapper.ElementType.class);
        } else {
            this.dimensions = null;
            this.similarityMeasure = SimilarityMeasure.COSINE;
            this.elementType = DenseVectorFieldMapper.ElementType.FLOAT;
        }
    }

    private CustomElandInternalTextEmbeddingServiceSettings(CommonFields commonFields) {
        this(commonFields, null);
    }

    private CustomElandInternalTextEmbeddingServiceSettings(CommonFields commonFields, Integer dimensions) {
        this.internalServiceSettings = commonFields.internalServiceSettings;
        this.dimensions = dimensions;
        this.similarityMeasure = commonFields.similarityMeasure;
        this.elementType = commonFields.elementType;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.internalServiceSettings.addXContentFragment(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.similarityMeasure != null) {
            builder.field("similarity", (Enum)this.similarityMeasure);
        }
        if (this.elementType != null) {
            builder.field("element_type", (Enum)this.elementType);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.internalServiceSettings.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_ELAND_SETTINGS_ADDED)) {
            out.writeOptionalVInt(this.dimensions);
            out.writeEnum((Enum)this.similarityMeasure);
            out.writeEnum((Enum)this.elementType);
        }
    }

    public ElasticsearchInternalServiceSettings getElasticsearchInternalServiceSettings() {
        return this.internalServiceSettings;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.elementType;
    }

    public SimilarityMeasure similarity() {
        return this.similarityMeasure;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomElandInternalTextEmbeddingServiceSettings that = (CustomElandInternalTextEmbeddingServiceSettings)o;
        return Objects.equals(this.internalServiceSettings, that.internalServiceSettings) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.similarityMeasure, that.similarityMeasure) && Objects.equals(this.elementType, that.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.internalServiceSettings, this.dimensions, this.similarityMeasure, this.elementType);
    }

    private record CommonFields(ElasticsearchInternalServiceSettings internalServiceSettings, SimilarityMeasure similarityMeasure, DenseVectorFieldMapper.ElementType elementType) {
    }
}

