/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.embeddings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereTruncation;

public class CohereEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "cohere_embeddings_task_settings";
    public static final CohereEmbeddingsTaskSettings EMPTY_SETTINGS = new CohereEmbeddingsTaskSettings(null, null);
    static final String INPUT_TYPE = "input_type";
    static final EnumSet<InputType> VALID_REQUEST_VALUES = EnumSet.of(InputType.INGEST, InputType.SEARCH, InputType.CLASSIFICATION, InputType.CLUSTERING);
    private final InputType inputType;
    private final CohereTruncation truncation;

    public static CohereEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, VALID_REQUEST_VALUES, validationException);
        CohereTruncation truncation = ServiceUtils.extractOptionalEnum(map, "truncate", "task_settings", CohereTruncation::fromString, EnumSet.allOf(CohereTruncation.class), validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereEmbeddingsTaskSettings(inputType, truncation);
    }

    public static CohereEmbeddingsTaskSettings of(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings, InputType requestInputType) {
        InputType inputTypeToUse = CohereEmbeddingsTaskSettings.getValidInputType(originalSettings, requestTaskSettings, requestInputType);
        CohereTruncation truncationToUse = CohereEmbeddingsTaskSettings.getValidTruncation(originalSettings, requestTaskSettings);
        return new CohereEmbeddingsTaskSettings(inputTypeToUse, truncationToUse);
    }

    private static InputType getValidInputType(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings, InputType requestInputType) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (VALID_REQUEST_VALUES.contains(requestInputType)) {
            inputTypeToUse = requestInputType;
        } else if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    private static CohereTruncation getValidTruncation(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings) {
        return requestTaskSettings.getTruncation() == null ? originalSettings.truncation : requestTaskSettings.getTruncation();
    }

    public CohereEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class), (CohereTruncation)in.readOptionalEnum(CohereTruncation.class));
    }

    public CohereEmbeddingsTaskSettings(@Nullable InputType inputType, @Nullable CohereTruncation truncation) {
        CohereEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.truncation = truncation;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (VALID_REQUEST_VALUES.contains(inputType)) : CohereEmbeddingsTaskSettings.invalidInputTypeMessage(inputType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.truncation != null) {
            builder.field("truncate", (Enum)this.truncation);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public CohereTruncation getTruncation() {
        return this.truncation;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        out.writeOptionalEnum((Enum)this.truncation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereEmbeddingsTaskSettings that = (CohereEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals((Object)this.truncation, (Object)that.truncation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputType, this.truncation});
    }

    public static String invalidInputTypeMessage(InputType inputType) {
        return Strings.format((String)"received invalid input type value [%s]", (Object[])new Object[]{inputType.toString()});
    }
}

