/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.embeddings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingType;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;

public class CohereEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "cohere_embeddings_service_settings";
    static final String EMBEDDING_TYPE = "embedding_type";
    private final CohereServiceSettings commonSettings;
    private final CohereEmbeddingType embeddingType;

    public static CohereEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        CohereServiceSettings commonServiceSettings = CohereServiceSettings.fromMap(map, context);
        CohereEmbeddingType embeddingTypes = CohereEmbeddingsServiceSettings.parseEmbeddingType(map, context, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereEmbeddingsServiceSettings(commonServiceSettings, embeddingTypes);
    }

    static CohereEmbeddingType parseEmbeddingType(Map<String, Object> map, ConfigurationParseContext context, ValidationException validationException) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationParseContext.REQUEST -> Objects.requireNonNullElse(ServiceUtils.extractOptionalEnum(map, EMBEDDING_TYPE, "service_settings", CohereEmbeddingType::fromString, EnumSet.allOf(CohereEmbeddingType.class), validationException), CohereEmbeddingType.FLOAT);
            case ConfigurationParseContext.PERSISTENT -> {
                String embeddingType = ServiceUtils.extractOptionalString(map, EMBEDDING_TYPE, "service_settings", validationException);
                yield CohereEmbeddingsServiceSettings.fromCohereOrDenseVectorEnumValues(embeddingType, validationException);
            }
        };
    }

    static CohereEmbeddingType fromCohereOrDenseVectorEnumValues(String enumString, ValidationException validationException) {
        if (enumString == null) {
            return CohereEmbeddingType.FLOAT;
        }
        try {
            return CohereEmbeddingType.fromString(enumString);
        }
        catch (IllegalArgumentException ae) {
            try {
                return CohereEmbeddingType.fromElementType(DenseVectorFieldMapper.ElementType.fromString((String)enumString));
            }
            catch (IllegalArgumentException iae) {
                String[] validValuesAsStrings = (String[])CohereEmbeddingType.SUPPORTED_ELEMENT_TYPES.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
                validationException.addValidationError(ServiceUtils.invalidValue(EMBEDDING_TYPE, "service_settings", enumString, validValuesAsStrings));
                return null;
            }
        }
    }

    public CohereEmbeddingsServiceSettings(CohereServiceSettings commonSettings, CohereEmbeddingType embeddingType) {
        this.commonSettings = commonSettings;
        this.embeddingType = Objects.requireNonNull(embeddingType);
    }

    public CohereEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new CohereServiceSettings(in);
        this.embeddingType = Objects.requireNonNullElse((CohereEmbeddingType)in.readOptionalEnum(CohereEmbeddingType.class), CohereEmbeddingType.FLOAT);
    }

    public CohereServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public SimilarityMeasure similarity() {
        return this.commonSettings.similarity();
    }

    public Integer dimensions() {
        return this.commonSettings.dimensions();
    }

    public CohereEmbeddingType getEmbeddingType() {
        return this.embeddingType;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.embeddingType == null ? DenseVectorFieldMapper.ElementType.FLOAT : this.embeddingType.toElementType();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.commonSettings.toXContentFragment(builder, params);
        builder.field(EMBEDDING_TYPE, (Enum)this.elementType());
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.commonSettings.toXContentFragmentOfExposedFields(builder, params);
        builder.field(EMBEDDING_TYPE, (Enum)this.elementType());
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
        out.writeOptionalEnum((Enum)CohereEmbeddingType.translateToVersion(this.embeddingType, out.getTransportVersion()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereEmbeddingsServiceSettings that = (CohereEmbeddingsServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings) && Objects.equals((Object)this.embeddingType, (Object)that.embeddingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonSettings, this.embeddingType});
    }
}

