/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereModel;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankModel;

public class CohereService
extends SenderService {
    public static final String NAME = "cohere";

    public CohereService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            CohereModel model = CohereService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    private static CohereModel createModelWithoutLoggingDeprecations(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        return CohereService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    private static CohereModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new CohereEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            case TaskType.RERANK -> new CohereRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            case TaskType.COMPLETION -> new CohereCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            default -> throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public CohereModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return CohereService.createModelWithoutLoggingDeprecations(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public CohereModel parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        return CohereService.createModelWithoutLoggingDeprecations(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    @Override
    public void doInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof CohereModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        CohereModel cohereModel = (CohereModel)model;
        CohereActionCreator actionCreator = new CohereActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = cohereModel.accept(actionCreator, taskSettings, inputType);
        action.execute(new QueryAndDocsInputs(query, input), timeout, listener);
    }

    @Override
    public void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof CohereModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        CohereModel cohereModel = (CohereModel)model;
        CohereActionCreator actionCreator = new CohereActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = cohereModel.accept(actionCreator, taskSettings, inputType);
        action.execute(new DocumentsOnlyInput(input), timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        if (!(model instanceof CohereModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        CohereModel cohereModel = (CohereModel)model;
        CohereActionCreator actionCreator = new CohereActionCreator(this.getSender(), this.getServiceComponents());
        List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(input, 96, EmbeddingRequestChunker.EmbeddingType.fromDenseVectorElementType(model.getServiceSettings().elementType())).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = cohereModel.accept(actionCreator, taskSettings, inputType);
            action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
        }
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof CohereEmbeddingsModel) {
            CohereEmbeddingsModel embeddingsModel = (CohereEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private CohereEmbeddingsModel updateModelWithEmbeddingDetails(CohereEmbeddingsModel model, int embeddingSize) {
        SimilarityMeasure userDefinedSimilarity = model.getServiceSettings().similarity();
        SimilarityMeasure similarityToUse = userDefinedSimilarity == null ? CohereService.defaultSimilarity() : userDefinedSimilarity;
        CohereEmbeddingsServiceSettings serviceSettings = new CohereEmbeddingsServiceSettings(new CohereServiceSettings(model.getServiceSettings().getCommonSettings().uri(), similarityToUse, (Integer)embeddingSize, model.getServiceSettings().getCommonSettings().maxInputTokens(), model.getServiceSettings().getCommonSettings().modelId(), model.getServiceSettings().getCommonSettings().rateLimitSettings()), model.getServiceSettings().getEmbeddingType());
        return new CohereEmbeddingsModel(model, serviceSettings);
    }

    static SimilarityMeasure defaultSimilarity() {
        return SimilarityMeasure.DOT_PRODUCT;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_RATE_LIMIT_SETTINGS_ADDED;
    }
}

