/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.completion;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AzureOpenAiCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
AzureOpenAiRateLimitServiceSettings {
    public static final String NAME = "azure_openai_completions_service_settings";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(120L);
    private final String resourceName;
    private final String deploymentId;
    private final String apiVersion;
    private final RateLimitSettings rateLimitSettings;

    public static AzureOpenAiCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        CommonFields settings = AzureOpenAiCompletionServiceSettings.fromMap(map, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureOpenAiCompletionServiceSettings(settings);
    }

    private static CommonFields fromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        String resourceName = ServiceUtils.extractRequiredString(map, "resource_name", "service_settings", validationException);
        String deploymentId = ServiceUtils.extractRequiredString(map, "deployment_id", "service_settings", validationException);
        String apiVersion = ServiceUtils.extractRequiredString(map, "api_version", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "azureopenai", context);
        return new CommonFields(resourceName, deploymentId, apiVersion, rateLimitSettings);
    }

    public AzureOpenAiCompletionServiceSettings(String resourceName, String deploymentId, String apiVersion, @Nullable RateLimitSettings rateLimitSettings) {
        this.resourceName = resourceName;
        this.deploymentId = deploymentId;
        this.apiVersion = apiVersion;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public AzureOpenAiCompletionServiceSettings(StreamInput in) throws IOException {
        this.resourceName = in.readString();
        this.deploymentId = in.readString();
        this.apiVersion = in.readString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    private AzureOpenAiCompletionServiceSettings(CommonFields fields) {
        this(fields.resourceName, fields.deploymentId, fields.apiVersion, fields.rateLimitSettings);
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String deploymentId() {
        return this.deploymentId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("resource_name", this.resourceName);
        builder.field("deployment_id", this.deploymentId);
        builder.field("api_version", this.apiVersion);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_OPENAI_COMPLETIONS;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resourceName);
        out.writeString(this.deploymentId);
        out.writeString(this.apiVersion);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzureOpenAiCompletionServiceSettings that = (AzureOpenAiCompletionServiceSettings)object;
        return Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.deploymentId, that.deploymentId) && Objects.equals(this.apiVersion, that.apiVersion) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.deploymentId, this.apiVersion, this.rateLimitSettings);
    }

    private record CommonFields(String resourceName, String deploymentId, String apiVersion, RateLimitSettings rateLimitSettings) {
    }
}

