/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureaistudio.AzureAiStudioActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProviderCapabilities;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsServiceSettings;

public class AzureAiStudioService
extends SenderService {
    static final String NAME = "azureaistudio";

    public AzureAiStudioService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    @Override
    protected void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        AzureAiStudioActionCreator actionCreator = new AzureAiStudioActionCreator(this.getSender(), this.getServiceComponents());
        if (model instanceof AzureAiStudioModel) {
            AzureAiStudioModel baseAzureAiStudioModel = (AzureAiStudioModel)model;
            ExecutableAction action = baseAzureAiStudioModel.accept(actionCreator, taskSettings);
            action.execute(new DocumentsOnlyInput(input), timeout, listener);
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    @Override
    protected void doInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        throw new UnsupportedOperationException("Azure AI Studio service does not support inference with query input");
    }

    @Override
    protected void doChunkedInfer(Model model, String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        if (model instanceof AzureAiStudioModel) {
            AzureAiStudioModel baseAzureAiStudioModel = (AzureAiStudioModel)model;
            AzureAiStudioActionCreator actionCreator = new AzureAiStudioActionCreator(this.getSender(), this.getServiceComponents());
            List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(input, 2048, EmbeddingRequestChunker.EmbeddingType.FLOAT).batchRequestsWithListeners(listener);
            for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
                ExecutableAction action = baseAzureAiStudioModel.accept(actionCreator, taskSettings);
                action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
            }
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            AzureAiStudioModel model = AzureAiStudioService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public AzureAiStudioModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public String name() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_AI_STUDIO;
    }

    private static AzureAiStudioModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        if (taskType == TaskType.TEXT_EMBEDDING) {
            AzureAiStudioEmbeddingsModel embeddingsModel = new AzureAiStudioEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            AzureAiStudioService.checkProviderAndEndpointTypeForTask(TaskType.TEXT_EMBEDDING, embeddingsModel.getServiceSettings().provider(), embeddingsModel.getServiceSettings().endpointType());
            return embeddingsModel;
        }
        if (taskType == TaskType.COMPLETION) {
            AzureAiStudioChatCompletionModel completionModel = new AzureAiStudioChatCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            AzureAiStudioService.checkProviderAndEndpointTypeForTask(TaskType.COMPLETION, completionModel.getServiceSettings().provider(), completionModel.getServiceSettings().endpointType());
            return completionModel;
        }
        throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private AzureAiStudioModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secretSettings, String failureMessage) {
        return AzureAiStudioService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof AzureAiStudioEmbeddingsModel) {
            AzureAiStudioEmbeddingsModel embeddingsModel = (AzureAiStudioEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateEmbeddingModelConfig(embeddingsModel, (int)size))));
        } else if (model instanceof AzureAiStudioChatCompletionModel) {
            AzureAiStudioChatCompletionModel chatCompletionModel = (AzureAiStudioChatCompletionModel)model;
            listener.onResponse((Object)this.updateChatCompletionModelConfig(chatCompletionModel));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private AzureAiStudioEmbeddingsModel updateEmbeddingModelConfig(AzureAiStudioEmbeddingsModel embeddingsModel, int embeddingsSize) {
        if (embeddingsModel.getServiceSettings().dimensionsSetByUser() && embeddingsModel.getServiceSettings().dimensions() != null && embeddingsModel.getServiceSettings().dimensions() != embeddingsSize) {
            throw new ElasticsearchStatusException(Strings.format((String)"The retrieved embeddings size [%s] does not match the size specified in the settings [%s]. Please recreate the [%s] configuration with the correct dimensions", (Object[])new Object[]{embeddingsSize, embeddingsModel.getServiceSettings().dimensions(), embeddingsModel.getConfigurations().getInferenceEntityId()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
        SimilarityMeasure similarityFromModel = embeddingsModel.getServiceSettings().similarity();
        SimilarityMeasure similarityToUse = similarityFromModel == null ? SimilarityMeasure.DOT_PRODUCT : similarityFromModel;
        AzureAiStudioEmbeddingsServiceSettings serviceSettings = new AzureAiStudioEmbeddingsServiceSettings(embeddingsModel.getServiceSettings().target(), embeddingsModel.getServiceSettings().provider(), embeddingsModel.getServiceSettings().endpointType(), embeddingsSize, embeddingsModel.getServiceSettings().dimensionsSetByUser(), embeddingsModel.getServiceSettings().maxInputTokens(), similarityToUse, embeddingsModel.getServiceSettings().rateLimitSettings());
        return new AzureAiStudioEmbeddingsModel(embeddingsModel, serviceSettings);
    }

    private AzureAiStudioChatCompletionModel updateChatCompletionModelConfig(AzureAiStudioChatCompletionModel chatCompletionModel) {
        Integer modelMaxNewTokens = chatCompletionModel.getTaskSettings().maxNewTokens();
        Integer maxNewTokensToUse = modelMaxNewTokens == null ? AzureAiStudioChatCompletionTaskSettings.DEFAULT_MAX_NEW_TOKENS : modelMaxNewTokens;
        AzureAiStudioChatCompletionTaskSettings updatedTaskSettings = new AzureAiStudioChatCompletionTaskSettings(chatCompletionModel.getTaskSettings().temperature(), chatCompletionModel.getTaskSettings().topP(), chatCompletionModel.getTaskSettings().doSample(), maxNewTokensToUse);
        return new AzureAiStudioChatCompletionModel(chatCompletionModel, updatedTaskSettings);
    }

    private static void checkProviderAndEndpointTypeForTask(TaskType taskType, AzureAiStudioProvider provider, AzureAiStudioEndpointType endpointType) {
        if (!AzureAiStudioProviderCapabilities.providerAllowsTaskType(provider, taskType)) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] task type for provider [%s] is not available", (Object[])new Object[]{taskType, provider}), RestStatus.BAD_REQUEST, new Object[0]);
        }
        if (!AzureAiStudioProviderCapabilities.providerAllowsEndpointTypeForTask(provider, taskType, endpointType)) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] endpoint type with [%s] task type for provider [%s] is not available", (Object[])new Object[]{endpointType, taskType, provider}), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }
}

