/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.util.Map;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.amazonbedrock.AmazonBedrockActionVisitor;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AmazonBedrockModel
extends Model {
    protected String region;
    protected String model;
    protected AmazonBedrockProvider provider;
    protected RateLimitSettings rateLimitSettings;

    protected AmazonBedrockModel(ModelConfigurations modelConfigurations, ModelSecrets secrets) {
        super(modelConfigurations, secrets);
        this.setPropertiesFromServiceSettings((AmazonBedrockServiceSettings)modelConfigurations.getServiceSettings());
    }

    protected AmazonBedrockModel(Model model, TaskSettings taskSettings) {
        super(model, taskSettings);
        if (model instanceof AmazonBedrockModel) {
            AmazonBedrockModel bedrockModel = (AmazonBedrockModel)model;
            this.setPropertiesFromServiceSettings(bedrockModel.getServiceSettings());
        }
    }

    protected AmazonBedrockModel(Model model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
        if (serviceSettings instanceof AmazonBedrockServiceSettings) {
            AmazonBedrockServiceSettings bedrockServiceSettings = (AmazonBedrockServiceSettings)serviceSettings;
            this.setPropertiesFromServiceSettings(bedrockServiceSettings);
        }
    }

    protected AmazonBedrockModel(ModelConfigurations modelConfigurations) {
        super(modelConfigurations);
        this.setPropertiesFromServiceSettings((AmazonBedrockServiceSettings)modelConfigurations.getServiceSettings());
    }

    public String region() {
        return this.region;
    }

    public String model() {
        return this.model;
    }

    public AmazonBedrockProvider provider() {
        return this.provider;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    private void setPropertiesFromServiceSettings(AmazonBedrockServiceSettings serviceSettings) {
        this.region = serviceSettings.region();
        this.model = serviceSettings.model();
        this.provider = serviceSettings.provider();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
    }

    public abstract ExecutableAction accept(AmazonBedrockActionVisitor var1, Map<String, Object> var2);

    public AmazonBedrockServiceSettings getServiceSettings() {
        return (AmazonBedrockServiceSettings)super.getServiceSettings();
    }

    public AmazonBedrockSecretSettings getSecretSettings() {
        return (AmazonBedrockSecretSettings)super.getSecretSettings();
    }
}

