/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public abstract class SenderService
implements InferenceService {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public SenderService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        Objects.requireNonNull(factory);
        this.sender = factory.createSender();
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    protected Sender getSender() {
        return this.sender;
    }

    protected ServiceComponents getServiceComponents() {
        return this.serviceComponents;
    }

    public void infer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.init();
        if (query != null) {
            this.doInfer(model, query, input, taskSettings, inputType, timeout, listener);
        } else {
            this.doInfer(model, input, taskSettings, inputType, timeout, listener);
        }
    }

    public void chunkedInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        this.init();
        this.chunkedInfer(model, null, input, taskSettings, inputType, chunkingOptions, timeout, listener);
    }

    public void chunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        this.init();
        this.doChunkedInfer(model, null, input, taskSettings, inputType, chunkingOptions, timeout, listener);
    }

    protected abstract void doInfer(Model var1, List<String> var2, Map<String, Object> var3, InputType var4, TimeValue var5, ActionListener<InferenceServiceResults> var6);

    protected abstract void doInfer(Model var1, String var2, List<String> var3, Map<String, Object> var4, InputType var5, TimeValue var6, ActionListener<InferenceServiceResults> var7);

    protected abstract void doChunkedInfer(Model var1, @Nullable String var2, List<String> var3, Map<String, Object> var4, InputType var5, ChunkingOptions var6, TimeValue var7, ActionListener<List<ChunkedInferenceServiceResults>> var8);

    public void start(Model model, ActionListener<Boolean> listener) {
        this.init();
        this.doStart(model, listener);
    }

    protected void doStart(Model model, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    private void init() {
        this.sender.start();
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.sender);
    }
}

