/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankBuilder;

public class TextSimilarityRankRetrieverBuilder
extends RetrieverBuilder {
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_RETRIEVER_SUPPORTED = new NodeFeature("text_similarity_reranker_retriever_supported");
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField INFERENCE_ID_FIELD = new ParseField("inference_id", new String[0]);
    public static final ParseField INFERENCE_TEXT_FIELD = new ParseField("inference_text", new String[0]);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField RANK_WINDOW_SIZE_FIELD = new ParseField("rank_window_size", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final ConstructingObjectParser<TextSimilarityRankRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("text_similarity_reranker", args -> {
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[0];
        String inferenceId = (String)args[1];
        String inferenceText = (String)args[2];
        String field = (String)args[3];
        int rankWindowSize = args[4] == null ? 10 : (Integer)args[4];
        Float minScore = (Float)args[5];
        return new TextSimilarityRankRetrieverBuilder(retrieverBuilder, inferenceId, inferenceText, field, rankWindowSize, minScore);
    });
    private final RetrieverBuilder retrieverBuilder;
    private final String inferenceId;
    private final String inferenceText;
    private final String field;
    private final int rankWindowSize;
    private final Float minScore;

    public static TextSimilarityRankRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(TEXT_SIMILARITY_RERANKER_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [text_similarity_reranker]", new Object[0]);
        }
        if (!TextSimilarityRankBuilder.TEXT_SIMILARITY_RERANKER_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"text_similarity_reranker");
        }
        return (TextSimilarityRankRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public TextSimilarityRankRetrieverBuilder(RetrieverBuilder retrieverBuilder, String inferenceId, String inferenceText, String field, int rankWindowSize, Float minScore) {
        this.retrieverBuilder = retrieverBuilder;
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.rankWindowSize = rankWindowSize;
        this.minScore = minScore;
    }

    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        this.retrieverBuilder.extractToSearchSourceBuilder(searchSourceBuilder, compoundUsed);
        if (searchSourceBuilder.rankBuilder() != null) {
            throw new IllegalArgumentException("text similarity rank builder cannot be combined with other rank builders");
        }
        searchSourceBuilder.rankBuilder((RankBuilder)new TextSimilarityRankBuilder(this.field, this.inferenceId, this.inferenceText, this.rankWindowSize, this.minScore));
    }

    public String getName() {
        return "text_similarity_reranker";
    }

    public int rankWindowSize() {
        return this.rankWindowSize;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName());
        builder.startObject();
        builder.field(this.retrieverBuilder.getName(), (ToXContent)this.retrieverBuilder);
        builder.endObject();
        builder.field(INFERENCE_ID_FIELD.getPreferredName(), this.inferenceId);
        builder.field(INFERENCE_TEXT_FIELD.getPreferredName(), this.inferenceText);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
    }

    protected boolean doEquals(Object other) {
        TextSimilarityRankRetrieverBuilder that = (TextSimilarityRankRetrieverBuilder)((Object)other);
        return Objects.equals(this.retrieverBuilder, that.retrieverBuilder) && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.field, that.field) && Objects.equals(this.rankWindowSize, that.rankWindowSize) && Objects.equals(this.minScore, that.minScore);
    }

    protected int doHashCode() {
        return Objects.hash(this.retrieverBuilder, this.inferenceId, this.inferenceText, this.field, this.rankWindowSize, this.minScore);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c), RETRIEVER_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INFERENCE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INFERENCE_TEXT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), MIN_SCORE_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)"text_similarity_reranker", PARSER);
    }
}

