/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.rerank.RerankingQueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.rerank.RerankingQueryPhaseRankShardContext;
import org.elasticsearch.search.rank.rerank.RerankingRankFeaturePhaseRankShardContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankRetrieverBuilder;

public class TextSimilarityRankBuilder
extends RankBuilder {
    public static final String NAME = "text_similarity_reranker";
    public static final LicensedFeature.Momentary TEXT_SIMILARITY_RERANKER_FEATURE = LicensedFeature.momentary(null, (String)"text-similarity-reranker", (License.OperationMode)License.OperationMode.ENTERPRISE);
    static final ConstructingObjectParser<TextSimilarityRankBuilder, Void> PARSER = new ConstructingObjectParser("text_similarity_reranker", args -> {
        String inferenceId = (String)args[0];
        String inferenceText = (String)args[1];
        String field = (String)args[2];
        Integer rankWindowSize = args[3] == null ? 10 : (Integer)args[3];
        Float minScore = (Float)args[4];
        return new TextSimilarityRankBuilder(field, inferenceId, inferenceText, rankWindowSize, minScore);
    });
    private final String inferenceId;
    private final String inferenceText;
    private final String field;
    private final Float minScore;

    public TextSimilarityRankBuilder(String field, String inferenceId, String inferenceText, int rankWindowSize, Float minScore) {
        super(rankWindowSize);
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.minScore = minScore;
    }

    public TextSimilarityRankBuilder(StreamInput in) throws IOException {
        super(in);
        this.inferenceId = in.readString();
        this.inferenceText = in.readString();
        this.field = in.readString();
        this.minScore = in.readOptionalFloat();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.TEXT_SIMILARITY_RERANKER_RETRIEVER;
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.inferenceId);
        out.writeString(this.inferenceText);
        out.writeString(this.field);
        out.writeOptionalFloat(this.minScore);
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TextSimilarityRankRetrieverBuilder.INFERENCE_ID_FIELD.getPreferredName(), this.inferenceId);
        builder.field(TextSimilarityRankRetrieverBuilder.INFERENCE_TEXT_FIELD.getPreferredName(), this.inferenceText);
        builder.field(TextSimilarityRankRetrieverBuilder.FIELD_FIELD.getPreferredName(), this.field);
        if (this.minScore != null) {
            builder.field(TextSimilarityRankRetrieverBuilder.MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
    }

    public boolean isCompoundBuilder() {
        return false;
    }

    public Explanation explainHit(Explanation baseExplanation, RankDoc scoreDoc, List<String> queryNames) {
        if (scoreDoc == null) {
            return baseExplanation;
        }
        if (!baseExplanation.isMatch()) {
            return baseExplanation;
        }
        assert (scoreDoc instanceof RankFeatureDoc) : "ScoreDoc is not an instance of RankFeatureDoc";
        RankFeatureDoc rrfRankDoc = (RankFeatureDoc)scoreDoc;
        return Explanation.match((Number)Float.valueOf(rrfRankDoc.score), (String)("rank after reranking: [" + rrfRankDoc.rank + "] with score: [" + rrfRankDoc.score + "], using inference endpoint: [" + this.inferenceId + "] on document field: [" + this.field + "]"), (Explanation[])new Explanation[]{baseExplanation});
    }

    public QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> queries, int from) {
        return new RerankingQueryPhaseRankShardContext(queries, this.rankWindowSize());
    }

    public QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int size, int from) {
        return new RerankingQueryPhaseRankCoordinatorContext(this.rankWindowSize());
    }

    public RankFeaturePhaseRankShardContext buildRankFeaturePhaseShardContext() {
        return new RerankingRankFeaturePhaseRankShardContext(this.field);
    }

    public RankFeaturePhaseRankCoordinatorContext buildRankFeaturePhaseCoordinatorContext(int size, int from, Client client) {
        return new TextSimilarityRankFeaturePhaseRankCoordinatorContext(size, from, this.rankWindowSize(), client, this.inferenceId, this.inferenceText, this.minScore);
    }

    public String field() {
        return this.field;
    }

    public String inferenceId() {
        return this.inferenceId;
    }

    public String inferenceText() {
        return this.inferenceText;
    }

    public Float minScore() {
        return this.minScore;
    }

    protected boolean doEquals(RankBuilder other) {
        TextSimilarityRankBuilder that = (TextSimilarityRankBuilder)other;
        return Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.field, that.field) && Objects.equals(this.minScore, that.minScore);
    }

    protected int doHashCode() {
        return Objects.hash(this.inferenceId, this.inferenceText, this.field, this.minScore);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TextSimilarityRankRetrieverBuilder.INFERENCE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TextSimilarityRankRetrieverBuilder.INFERENCE_TEXT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TextSimilarityRankRetrieverBuilder.FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), TextSimilarityRankRetrieverBuilder.MIN_SCORE_FIELD);
    }
}

