/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.search.WeightedToken;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;

public class SemanticTextFieldMapper
extends FieldMapper
implements InferenceFieldMapper {
    public static final String CONTENT_TYPE = "semantic_text";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), arg_0 -> ((MappingParserContext)c).bitSetProducer(arg_0)), List.of(SemanticTextFieldMapper.notInMultiFields((String)"semantic_text"), SemanticTextFieldMapper.notFromDynamicTemplates((String)"semantic_text")));

    private SemanticTextFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), copyTo);
    }

    public Iterator<Mapper> iterator() {
        ArrayList<ObjectMapper> subIterators = new ArrayList<ObjectMapper>();
        subIterators.add(this.fieldType().getInferenceField());
        return subIterators.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.fieldType().indexVersionCreated, this.fieldType().getChunksField().bitsetProducer()).init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        SemanticTextFieldMapper mapper;
        SemanticTextField field;
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        XContentLocation xContentLocation = parser.getTokenLocation();
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        try {
            context.path().setWithinLeafObject(true);
            field = SemanticTextField.parse(parser, (Tuple<String, XContentType>)new Tuple((Object)this.fullPath(), (Object)context.parser().contentType()));
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
        String fullFieldName = this.fieldType().name();
        if (!field.inference().inferenceId().equals(this.fieldType().getInferenceId())) {
            throw new DocumentParsingException(xContentLocation, Strings.format((String)"The configured %s [%s] for field [%s] doesn't match the %s [%s] reported in the document.", (Object[])new Object[]{"inference_id", field.inference().inferenceId(), fullFieldName, "inference_id", this.fieldType().getInferenceId()}));
        }
        if (this.fieldType().getModelSettings() == null) {
            context.path().remove();
            Builder builder = (Builder)new Builder(this.leafName(), this.fieldType().indexVersionCreated, this.fieldType().getChunksField().bitsetProducer()).init(this);
            try {
                mapper = builder.setModelSettings(field.inference().modelSettings()).setInferenceId(field.inference().inferenceId()).build(context.createDynamicMapperBuilderContext());
                context.addDynamicMapper((Mapper)mapper);
            }
            finally {
                context.path().add(this.leafName());
            }
        }
        FieldMapper.Conflicts conflicts = new FieldMapper.Conflicts(fullFieldName);
        SemanticTextFieldMapper.canMergeModelSettings(field.inference().modelSettings(), this.fieldType().getModelSettings(), conflicts);
        try {
            conflicts.check();
        }
        catch (Exception exc) {
            throw new DocumentParsingException(xContentLocation, "Incompatible model settings for field [" + this.fullPath() + "]. Check that the inference_id is not using different model settings", exc);
        }
        mapper = this;
        NestedObjectMapper chunksField = mapper.fieldType().getChunksField();
        FieldMapper embeddingsField = mapper.fieldType().getEmbeddingsField();
        for (SemanticTextField.Chunk chunk : field.inference().chunks()) {
            XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings(), (XContentType)context.parser().contentType());
            try {
                DocumentParserContext subContext = context.createNestedContext(chunksField).switchParser(subParser);
                subParser.nextToken();
                embeddingsField.parse(subContext);
            }
            finally {
                if (subParser == null) continue;
                subParser.close();
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public SemanticTextFieldType fieldType() {
        return (SemanticTextFieldType)super.fieldType();
    }

    public InferenceFieldMetadata getMetadata(Set<String> sourcePaths) {
        Object[] copyFields = (String[])sourcePaths.toArray(String[]::new);
        Arrays.sort(copyFields);
        return new InferenceFieldMetadata(this.fullPath(), this.fieldType().inferenceId, (String[])copyFields);
    }

    public Object getOriginalValue(Map<String, Object> sourceAsMap) {
        Object fieldValue = sourceAsMap.get(this.fullPath());
        if (fieldValue == null) {
            return null;
        }
        if (!(fieldValue instanceof Map)) {
            return fieldValue;
        }
        Map fieldValueMap = XContentMapValues.nodeMapValue((Object)fieldValue, (String)("Field [" + this.fullPath() + "]"));
        return XContentMapValues.extractValue((String)"text", (Map)fieldValueMap);
    }

    private static ObjectMapper createInferenceField(MapperBuilderContext context, IndexVersion indexVersionCreated, @Nullable SemanticTextField.ModelSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer) {
        return new ObjectMapper.Builder("inference", Explicit.EXPLICIT_TRUE).dynamic(ObjectMapper.Dynamic.FALSE).add((Mapper.Builder)SemanticTextFieldMapper.createChunksField(indexVersionCreated, modelSettings, bitSetProducer)).build(context);
    }

    private static NestedObjectMapper.Builder createChunksField(IndexVersion indexVersionCreated, @Nullable SemanticTextField.ModelSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer) {
        NestedObjectMapper.Builder chunksField = new NestedObjectMapper.Builder("chunks", indexVersionCreated, bitSetProducer);
        chunksField.dynamic(ObjectMapper.Dynamic.FALSE);
        KeywordFieldMapper.Builder chunkTextField = new KeywordFieldMapper.Builder("text", indexVersionCreated).indexed(false).docValues(false);
        if (modelSettings != null) {
            chunksField.add(SemanticTextFieldMapper.createEmbeddingsField(indexVersionCreated, modelSettings));
        }
        chunksField.add((Mapper.Builder)chunkTextField);
        return chunksField;
    }

    private static Mapper.Builder createEmbeddingsField(IndexVersion indexVersionCreated, SemanticTextField.ModelSettings modelSettings) {
        return switch (modelSettings.taskType()) {
            case TaskType.SPARSE_EMBEDDING -> new SparseVectorFieldMapper.Builder("embeddings");
            case TaskType.TEXT_EMBEDDING -> {
                DenseVectorFieldMapper.Builder denseVectorMapperBuilder = new DenseVectorFieldMapper.Builder("embeddings", indexVersionCreated);
                SimilarityMeasure similarity = modelSettings.similarity();
                if (similarity != null) {
                    switch (similarity) {
                        case COSINE: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.COSINE);
                            break;
                        }
                        case DOT_PRODUCT: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.DOT_PRODUCT);
                            break;
                        }
                        case L2_NORM: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.L2_NORM);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown similarity measure in model_settings [" + similarity.name() + "]");
                        }
                    }
                }
                denseVectorMapperBuilder.dimensions(modelSettings.dimensions().intValue());
                denseVectorMapperBuilder.elementType(modelSettings.elementType());
                yield denseVectorMapperBuilder;
            }
            default -> throw new IllegalArgumentException("Invalid task_type in model_settings [" + modelSettings.taskType().name() + "]");
        };
    }

    private static boolean canMergeModelSettings(SemanticTextField.ModelSettings previous, SemanticTextField.ModelSettings current, FieldMapper.Conflicts conflicts) {
        if (Objects.equals(previous, current)) {
            return true;
        }
        if (previous == null) {
            return true;
        }
        conflicts.addConflict("model_settings", "");
        return false;
    }

    public static class SemanticTextFieldType
    extends SimpleMappedFieldType {
        private final String inferenceId;
        private final SemanticTextField.ModelSettings modelSettings;
        private final ObjectMapper inferenceField;
        private final IndexVersion indexVersionCreated;

        public SemanticTextFieldType(String name, String inferenceId, SemanticTextField.ModelSettings modelSettings, ObjectMapper inferenceField, IndexVersion indexVersionCreated, Map<String, String> meta) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
            this.inferenceId = inferenceId;
            this.modelSettings = modelSettings;
            this.inferenceField = inferenceField;
            this.indexVersionCreated = indexVersionCreated;
        }

        public String typeName() {
            return SemanticTextFieldMapper.CONTENT_TYPE;
        }

        public String getInferenceId() {
            return this.inferenceId;
        }

        public SemanticTextField.ModelSettings getModelSettings() {
            return this.modelSettings;
        }

        public ObjectMapper getInferenceField() {
            return this.inferenceField;
        }

        public NestedObjectMapper getChunksField() {
            return (NestedObjectMapper)this.inferenceField.getMapper("chunks");
        }

        public FieldMapper getEmbeddingsField() {
            return (FieldMapper)this.getChunksField().getMapper("embeddings");
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("semantic_text fields do not support term query");
        }

        public Query existsQuery(SearchExecutionContext context) {
            if (this.getEmbeddingsField() == null) {
                return new MatchNoDocsQuery();
            }
            return NestedQueryBuilder.toQuery(c -> this.getEmbeddingsField().fieldType().existsQuery(c), (String)SemanticTextField.getChunksFieldName(this.name()), (ScoreMode)ScoreMode.None, (boolean)false, (SearchExecutionContext)context);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)SemanticTextField.getOriginalTextFieldName(this.name()), (SearchExecutionContext)context, (String)format);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[semantic_text] fields do not support sorting, scripting or aggregating");
        }

        public QueryBuilder semanticQuery(InferenceResults inferenceResults, float boost, String queryName) {
            MatchNoneQueryBuilder childQueryBuilder;
            String nestedFieldPath = SemanticTextField.getChunksFieldName(this.name());
            String inferenceResultsFieldName = SemanticTextField.getEmbeddingsFieldName(this.name());
            if (this.modelSettings == null) {
                childQueryBuilder = new MatchNoneQueryBuilder();
            } else {
                childQueryBuilder = switch (this.modelSettings.taskType()) {
                    case TaskType.SPARSE_EMBEDDING -> {
                        if (!(inferenceResults instanceof TextExpansionResults)) {
                            throw new IllegalArgumentException("Field [" + this.name() + "] expected query inference results to be of type [text_expansion_result], got [" + inferenceResults.getWriteableName() + "]. Has the inference endpoint configuration changed?");
                        }
                        TextExpansionResults textExpansionResults = (TextExpansionResults)inferenceResults;
                        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                        for (WeightedToken weightedToken : textExpansionResults.getWeightedTokens()) {
                            boolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)inferenceResultsFieldName, (String)weightedToken.token()).boost(weightedToken.weight()));
                        }
                        boolQuery.minimumShouldMatch(1);
                        yield boolQuery;
                    }
                    case TaskType.TEXT_EMBEDDING -> {
                        if (!(inferenceResults instanceof MlTextEmbeddingResults)) {
                            throw new IllegalArgumentException("Field [" + this.name() + "] expected query inference results to be of type [text_embedding_result], got [" + inferenceResults.getWriteableName() + "]. Has the inference endpoint configuration changed?");
                        }
                        MlTextEmbeddingResults textEmbeddingResults = (MlTextEmbeddingResults)inferenceResults;
                        float[] inference = textEmbeddingResults.getInferenceAsFloat();
                        if (inference.length != this.modelSettings.dimensions()) {
                            throw new IllegalArgumentException("Field [" + this.name() + "] expected query inference results with " + this.modelSettings.dimensions() + " dimensions, got " + inference.length + " dimensions. Has the inference endpoint configuration changed?");
                        }
                        yield new KnnVectorQueryBuilder(inferenceResultsFieldName, inference, null, null, null);
                    }
                    default -> throw new IllegalStateException("Field [" + this.name() + "] configured to use an inference endpoint with an unsupported task type [" + this.modelSettings.taskType() + "]");
                };
            }
            return ((NestedQueryBuilder)new NestedQueryBuilder(nestedFieldPath, (QueryBuilder)childQueryBuilder, ScoreMode.Max).boost(boost)).queryName(queryName);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexVersionCreated;
        private final FieldMapper.Parameter<String> inferenceId = FieldMapper.Parameter.stringParam((String)"inference_id", (boolean)false, mapper -> ((SemanticTextFieldType)mapper.fieldType()).inferenceId, null).addValidator(v -> {
            if (Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("field [inference_id] must be specified");
            }
        });
        private final FieldMapper.Parameter<SemanticTextField.ModelSettings> modelSettings = new FieldMapper.Parameter("model_settings", true, () -> null, (n, c, o) -> SemanticTextField.parseModelSettingsFromMap(o), mapper -> ((SemanticTextFieldType)mapper.fieldType()).modelSettings, XContentBuilder::field, Objects::toString).acceptsNull().setMergeValidator(SemanticTextFieldMapper::canMergeModelSettings);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private Function<MapperBuilderContext, ObjectMapper> inferenceFieldBuilder;

        public Builder(String name, IndexVersion indexVersionCreated, Function<Query, BitSetProducer> bitSetProducer) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.inferenceFieldBuilder = c -> SemanticTextFieldMapper.createInferenceField(c, indexVersionCreated, (SemanticTextField.ModelSettings)this.modelSettings.get(), bitSetProducer);
        }

        public Builder setInferenceId(String id) {
            this.inferenceId.setValue((Object)id);
            return this;
        }

        public Builder setModelSettings(SemanticTextField.ModelSettings value) {
            this.modelSettings.setValue((Object)value);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.inferenceId, this.modelSettings, this.meta};
        }

        protected void merge(FieldMapper mergeWith, FieldMapper.Conflicts conflicts, MapperMergeContext mapperMergeContext) {
            super.merge(mergeWith, conflicts, mapperMergeContext);
            conflicts.check();
            SemanticTextFieldMapper semanticMergeWith = (SemanticTextFieldMapper)mergeWith;
            MapperMergeContext context = mapperMergeContext.createChildContext(mergeWith.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(context.getMapperBuilderContext());
            ObjectMapper mergedInferenceField = inferenceField.merge((Mapper)semanticMergeWith.fieldType().getInferenceField(), context);
            this.inferenceFieldBuilder = c -> mergedInferenceField;
        }

        public SemanticTextFieldMapper build(MapperBuilderContext context) {
            if (!this.copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support [copy_to]");
            }
            if (this.multiFieldsBuilder.hasMultiFields()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support multi-fields");
            }
            String fullName = context.buildFullName(this.leafName());
            if (context.isInNestedContext()) {
                throw new IllegalArgumentException("semantic_text field [" + fullName + "] cannot be nested");
            }
            MapperBuilderContext childContext = context.createChildContext(this.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(childContext);
            return new SemanticTextFieldMapper(this.leafName(), (MappedFieldType)new SemanticTextFieldType(fullName, (String)this.inferenceId.getValue(), (SemanticTextField.ModelSettings)this.modelSettings.getValue(), inferenceField, this.indexVersionCreated, (Map)this.meta.getValue()), this.copyTo);
        }
    }
}

