/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.amazonbedrock.completion;

import com.amazonaws.services.bedrockruntime.model.ContentBlock;
import com.amazonaws.services.bedrockruntime.model.ConverseResult;
import com.amazonaws.services.bedrockruntime.model.Message;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.AmazonBedrockResponse;

public class AmazonBedrockChatCompletionResponse
extends AmazonBedrockResponse {
    private final ConverseResult result;

    public AmazonBedrockChatCompletionResponse(ConverseResult responseResult) {
        this.result = responseResult;
    }

    @Override
    public InferenceServiceResults accept(AmazonBedrockRequest request) {
        if (request instanceof AmazonBedrockChatCompletionRequest) {
            AmazonBedrockChatCompletionRequest asChatCompletionRequest = (AmazonBedrockChatCompletionRequest)request;
            return AmazonBedrockChatCompletionResponse.fromResponse(this.result);
        }
        throw new ElasticsearchException("unexpected request type [" + request.getClass() + "]", new Object[0]);
    }

    public static ChatCompletionResults fromResponse(ConverseResult response) {
        Message responseMessage = response.getOutput().getMessage();
        List messageContents = responseMessage.getContent();
        ArrayList<ChatCompletionResults.Result> resultTexts = new ArrayList<ChatCompletionResults.Result>();
        for (ContentBlock messageContent : messageContents) {
            resultTexts.add(new ChatCompletionResults.Result(messageContent.getText()));
        }
        return new ChatCompletionResults(resultTexts);
    }
}

