/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googlevertexai;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record GoogleVertexAiEmbeddingsRequestEntity(List<String> inputs, @Nullable Boolean autoTruncation) implements ToXContentObject
{
    private static final String INSTANCES_FIELD = "instances";
    private static final String CONTENT_FIELD = "content";
    private static final String PARAMETERS_FIELD = "parameters";
    private static final String AUTO_TRUNCATE_FIELD = "autoTruncate";

    public GoogleVertexAiEmbeddingsRequestEntity {
        Objects.requireNonNull(inputs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INSTANCES_FIELD);
        for (String input : this.inputs) {
            builder.startObject();
            builder.field(CONTENT_FIELD, input);
            builder.endObject();
        }
        builder.endArray();
        if (this.autoTruncation != null) {
            builder.startObject(PARAMETERS_FIELD);
            builder.field(AUTO_TRUNCATE_FIELD, this.autoTruncation);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

