/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.azureopenai;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.azureopenai.AzureOpenAiCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.azureopenai.AzureOpenAiRequest;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionModel;

public class AzureOpenAiCompletionRequest
implements AzureOpenAiRequest {
    private final List<String> input;
    private final URI uri;
    private final AzureOpenAiCompletionModel model;

    public AzureOpenAiCompletionRequest(List<String> input, AzureOpenAiCompletionModel model) {
        this.input = input;
        this.model = Objects.requireNonNull(model);
        this.uri = model.getUri();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        String requestEntity = Strings.toString((ToXContent)new AzureOpenAiCompletionRequestEntity(this.input, this.model.getTaskSettings().user()));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        AzureOpenAiRequest.decorateWithAuthHeader(httpPost, this.model.getSecretSettings());
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

