/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion;

import com.amazonaws.services.bedrockruntime.model.ConverseRequest;
import com.amazonaws.services.bedrockruntime.model.InferenceConfiguration;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseUtils;

public record AmazonBedrockMetaCompletionRequestEntity(List<String> messages, @Nullable Double temperature, @Nullable Double topP, @Nullable Integer maxTokenCount) implements AmazonBedrockConverseRequestEntity
{
    public AmazonBedrockMetaCompletionRequestEntity {
        Objects.requireNonNull(messages);
    }

    @Override
    public ConverseRequest addMessages(ConverseRequest request) {
        return request.withMessages(AmazonBedrockConverseUtils.getConverseMessageList(this.messages));
    }

    @Override
    public ConverseRequest addInferenceConfig(ConverseRequest request) {
        if (this.temperature == null && this.topP == null && this.maxTokenCount == null) {
            return request;
        }
        InferenceConfiguration inferenceConfig = new InferenceConfiguration();
        if (this.temperature != null) {
            inferenceConfig = inferenceConfig.withTemperature(Float.valueOf(this.temperature.floatValue()));
        }
        if (this.topP != null) {
            inferenceConfig = inferenceConfig.withTopP(Float.valueOf(this.topP.floatValue()));
        }
        if (this.maxTokenCount != null) {
            inferenceConfig = inferenceConfig.withMaxTokens(this.maxTokenCount);
        }
        return request.withInferenceConfig(inferenceConfig);
    }

    @Override
    public ConverseRequest addAdditionalModelFields(ConverseRequest request) {
        return request;
    }
}

