/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion;

import com.amazonaws.services.bedrockruntime.model.ConverseRequest;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.completion.AmazonBedrockChatCompletionResponseListener;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;

public class AmazonBedrockChatCompletionRequest
extends AmazonBedrockRequest {
    public static final String USER_ROLE = "user";
    private final AmazonBedrockConverseRequestEntity requestEntity;
    private AmazonBedrockChatCompletionResponseListener listener;

    public AmazonBedrockChatCompletionRequest(AmazonBedrockChatCompletionModel model, AmazonBedrockConverseRequestEntity requestEntity, @Nullable TimeValue timeout) {
        super(model, timeout);
        this.requestEntity = Objects.requireNonNull(requestEntity);
    }

    @Override
    protected void executeRequest(AmazonBedrockBaseClient client) {
        ConverseRequest converseRequest = this.getConverseRequest();
        try {
            SocketAccess.doPrivileged(() -> client.converse(converseRequest, this.listener));
        }
        catch (IOException e) {
            this.listener.onFailure(new RuntimeException(e));
        }
    }

    @Override
    public TaskType taskType() {
        return TaskType.COMPLETION;
    }

    private ConverseRequest getConverseRequest() {
        ConverseRequest converseRequest = new ConverseRequest().withModelId(this.amazonBedrockModel.model());
        converseRequest = this.requestEntity.addMessages(converseRequest);
        converseRequest = this.requestEntity.addInferenceConfig(converseRequest);
        converseRequest = this.requestEntity.addAdditionalModelFields(converseRequest);
        return converseRequest;
    }

    public void executeChatCompletionRequest(AmazonBedrockBaseClient awsBedrockClient, AmazonBedrockChatCompletionResponseListener chatCompletionResponseListener) {
        this.listener = chatCompletionResponseListener;
        this.executeRequest(awsBedrockClient);
    }
}

