/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockAI21LabsCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockAnthropicCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockCohereCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockMetaCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockMistralCompletionRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockTitanCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;

public final class AmazonBedrockChatCompletionEntityFactory {
    public static AmazonBedrockConverseRequestEntity createEntity(AmazonBedrockChatCompletionModel model, List<String> messages) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(messages);
        AmazonBedrockChatCompletionServiceSettings serviceSettings = model.getServiceSettings();
        AmazonBedrockChatCompletionTaskSettings taskSettings = model.getTaskSettings();
        switch (serviceSettings.provider()) {
            case AI21LABS: {
                return new AmazonBedrockAI21LabsCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.maxNewTokens());
            }
            case AMAZONTITAN: {
                return new AmazonBedrockTitanCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.maxNewTokens());
            }
            case ANTHROPIC: {
                return new AmazonBedrockAnthropicCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.topK(), taskSettings.maxNewTokens());
            }
            case COHERE: {
                return new AmazonBedrockCohereCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.topK(), taskSettings.maxNewTokens());
            }
            case META: {
                return new AmazonBedrockMetaCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.maxNewTokens());
            }
            case MISTRAL: {
                return new AmazonBedrockMistralCompletionRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.topK(), taskSettings.maxNewTokens());
            }
        }
        return null;
    }
}

