/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.openai;

import org.apache.http.HttpResponse;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpUtils;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ContentTooLargeException;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandlerUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.openai.OpenAiErrorResponseEntity;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class OpenAiResponseHandler
extends BaseResponseHandler {
    static final String REQUESTS_LIMIT = "x-ratelimit-limit-requests";
    static final String TOKENS_LIMIT = "x-ratelimit-limit-tokens";
    static final String REMAINING_REQUESTS = "x-ratelimit-remaining-requests";
    static final String REMAINING_TOKENS = "x-ratelimit-remaining-tokens";
    static final String CONTENT_TOO_LARGE_MESSAGE = "Please reduce your prompt; or completion length.";
    static final String OPENAI_SERVER_BUSY = "Received a server busy error status code";

    public OpenAiResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, OpenAiErrorResponseEntity::fromResponse);
    }

    @Override
    public void validateResponse(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result) throws RetryException {
        this.checkForFailureStatusCode(request, result);
        HttpUtils.checkForEmptyBody(throttlerManager, logger, request, result);
    }

    void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 503) {
            throw new RetryException(true, this.buildError(OPENAI_SERVER_BUSY, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw this.buildExceptionHandling429(request, result);
        }
        if (OpenAiResponseHandler.isContentTooLarge(result)) {
            throw new ContentTooLargeException(this.buildError("Received a content too large status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    protected RetryException buildExceptionHandling429(Request request, HttpResult result) {
        return new RetryException(true, this.buildError(OpenAiResponseHandler.buildRateLimitErrorMessage(result), request, result));
    }

    private static boolean isContentTooLarge(HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 413) {
            return true;
        }
        if (statusCode == 400) {
            OpenAiErrorResponseEntity errorEntity = OpenAiErrorResponseEntity.fromResponse(result);
            return errorEntity != null && errorEntity.getErrorMessage().contains(CONTENT_TOO_LARGE_MESSAGE);
        }
        return false;
    }

    static String buildRateLimitErrorMessage(HttpResult result) {
        HttpResponse response = result.response();
        String tokenLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, TOKENS_LIMIT);
        String remainingTokens = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_TOKENS);
        String requestLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REQUESTS_LIMIT);
        String remainingRequests = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_REQUESTS);
        String usageMessage = Strings.format((String)"Token limit [%s], remaining tokens [%s]. Request limit [%s], remaining requests [%s]", (Object[])new Object[]{tokenLimit, remainingTokens, requestLimit, remainingRequests});
        return "Received a rate limit status code. " + usageMessage;
    }
}

