/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.googlevertexai.GoogleVertexAiResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleVertexAiRequestManager;
import org.elasticsearch.xpack.inference.external.request.googlevertexai.GoogleVertexAiRerankRequest;
import org.elasticsearch.xpack.inference.external.response.googlevertexai.GoogleVertexAiRerankResponseEntity;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankModel;

public class GoogleVertexAiRerankRequestManager
extends GoogleVertexAiRequestManager {
    private static final Logger logger = LogManager.getLogger(GoogleVertexAiRerankRequestManager.class);
    private static final ResponseHandler HANDLER = GoogleVertexAiRerankRequestManager.createGoogleVertexAiResponseHandler();
    private final GoogleVertexAiRerankModel model;

    private static ResponseHandler createGoogleVertexAiResponseHandler() {
        return new GoogleVertexAiResponseHandler("Google Vertex AI rerank", (request, response) -> GoogleVertexAiRerankResponseEntity.fromResponse(response));
    }

    public static GoogleVertexAiRerankRequestManager of(GoogleVertexAiRerankModel model, ThreadPool threadPool) {
        return new GoogleVertexAiRerankRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private GoogleVertexAiRerankRequestManager(GoogleVertexAiRerankModel model, ThreadPool threadPool) {
        super(threadPool, model, RateLimitGrouping.of(model));
        this.model = model;
    }

    @Override
    public void execute(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        GoogleVertexAiRerankRequest request = new GoogleVertexAiRerankRequest(query, input, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }

    record RateLimitGrouping(int projectIdHash) {
        public static RateLimitGrouping of(GoogleVertexAiRerankModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(model.rateLimitServiceSettings().projectId().hashCode());
        }
    }
}

