/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.googlevertexai.GoogleVertexAiResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleVertexAiRequestManager;
import org.elasticsearch.xpack.inference.external.request.googlevertexai.GoogleVertexAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.googlevertexai.GoogleVertexAiEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsModel;

public class GoogleVertexAiEmbeddingsRequestManager
extends GoogleVertexAiRequestManager {
    private static final Logger logger = LogManager.getLogger(GoogleVertexAiEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = GoogleVertexAiEmbeddingsRequestManager.createEmbeddingsHandler();
    private final GoogleVertexAiEmbeddingsModel model;
    private final Truncator truncator;

    private static ResponseHandler createEmbeddingsHandler() {
        return new GoogleVertexAiResponseHandler("google vertex ai embeddings", GoogleVertexAiEmbeddingsResponseEntity::fromResponse);
    }

    public GoogleVertexAiEmbeddingsRequestManager(GoogleVertexAiEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model, RateLimitGrouping.of(model));
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        Truncator.TruncationResult truncatedInput = Truncator.truncate(input, this.model.getServiceSettings().maxInputTokens());
        GoogleVertexAiEmbeddingsRequest request = new GoogleVertexAiEmbeddingsRequest(this.truncator, truncatedInput, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }

    record RateLimitGrouping(int projectIdHash) {
        public static RateLimitGrouping of(GoogleVertexAiEmbeddingsModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(model.rateLimitServiceSettings().projectId().hashCode());
        }
    }
}

