/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.googleaistudio.GoogleAiStudioResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleAiStudioRequestManager;
import org.elasticsearch.xpack.inference.external.request.googleaistudio.GoogleAiStudioEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.googleaistudio.GoogleAiStudioEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsModel;

public class GoogleAiStudioEmbeddingsRequestManager
extends GoogleAiStudioRequestManager {
    private static final Logger logger = LogManager.getLogger(GoogleAiStudioEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = GoogleAiStudioEmbeddingsRequestManager.createEmbeddingsHandler();
    private final GoogleAiStudioEmbeddingsModel model;
    private final Truncator truncator;

    private static ResponseHandler createEmbeddingsHandler() {
        return new GoogleAiStudioResponseHandler("google ai studio embeddings", GoogleAiStudioEmbeddingsResponseEntity::fromResponse);
    }

    public GoogleAiStudioEmbeddingsRequestManager(GoogleAiStudioEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        Truncator.TruncationResult truncatedInput = Truncator.truncate(input, this.model.getServiceSettings().maxInputTokens());
        GoogleAiStudioEmbeddingsRequest request = new GoogleAiStudioEmbeddingsRequest(this.truncator, truncatedInput, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

