/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.AmazonBedrockRequestManager;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockChatCompletionEntityFactory;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.completion.AmazonBedrockChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;

public class AmazonBedrockChatCompletionRequestManager
extends AmazonBedrockRequestManager {
    private static final Logger logger = LogManager.getLogger(AmazonBedrockChatCompletionRequestManager.class);
    private final AmazonBedrockChatCompletionModel model;

    public AmazonBedrockChatCompletionRequestManager(AmazonBedrockChatCompletionModel model, ThreadPool threadPool, @Nullable TimeValue timeout) {
        super(model, threadPool, timeout);
        this.model = model;
    }

    @Override
    public void execute(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        AmazonBedrockConverseRequestEntity requestEntity = AmazonBedrockChatCompletionEntityFactory.createEntity(this.model, input);
        AmazonBedrockChatCompletionRequest request = new AmazonBedrockChatCompletionRequest(this.model, requestEntity, this.timeout);
        AmazonBedrockChatCompletionResponseHandler responseHandler = new AmazonBedrockChatCompletionResponseHandler();
        try {
            requestSender.send(logger, request, HttpClientContext.create(), hasRequestCompletedFunction, responseHandler, listener);
        }
        catch (Exception e) {
            String errorMessage = Strings.format((String)"Failed to send [completion] request from inference entity id [%s]", (Object[])new Object[]{request.getInferenceEntityId()});
            logger.warn(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new ElasticsearchException(errorMessage, (Throwable)e, new Object[0])));
        }
    }
}

