/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.googlevertexai;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpUtils;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.googlevertexai.GoogleVertexAiErrorResponseEntity;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class GoogleVertexAiResponseHandler
extends BaseResponseHandler {
    static final String GOOGLE_VERTEX_AI_UNAVAILABLE = "The Google Vertex AI service may be temporarily overloaded or down";

    public GoogleVertexAiResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, GoogleVertexAiErrorResponseEntity::fromResponse);
    }

    @Override
    public void validateResponse(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result) throws RetryException {
        this.checkForFailureStatusCode(request, result);
        HttpUtils.checkForEmptyBody(throttlerManager, logger, request, result);
    }

    void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 503) {
            throw new RetryException(true, this.buildError(GOOGLE_VERTEX_AI_UNAVAILABLE, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 404) {
            throw new RetryException(false, this.buildError(GoogleVertexAiResponseHandler.resourceNotFoundError(request), request, result));
        }
        if (statusCode == 403) {
            throw new RetryException(false, this.buildError("Received a permission denied error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static String resourceNotFoundError(Request request) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{request.getURI()});
    }
}

