/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import com.amazonaws.http.IdleConnectionReaper;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockInferenceClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;

public final class AmazonBedrockInferenceClientCache
implements AmazonBedrockClientCache {
    private final BiFunction<AmazonBedrockModel, TimeValue, AmazonBedrockBaseClient> creator;
    private final Map<Integer, AmazonBedrockBaseClient> clientsCache = new ConcurrentHashMap<Integer, AmazonBedrockBaseClient>();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private Clock clock;

    public AmazonBedrockInferenceClientCache(BiFunction<AmazonBedrockModel, TimeValue, AmazonBedrockBaseClient> creator, @Nullable Clock clock) {
        this.creator = Objects.requireNonNull(creator);
        this.clock = Objects.requireNonNullElse(clock, Clock.systemUTC());
    }

    @Override
    public AmazonBedrockBaseClient getOrCreateClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        AmazonBedrockBaseClient returnClient = this.internalGetOrCreateClient(model, timeout);
        this.flushExpiredClients();
        return returnClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmazonBedrockBaseClient internalGetOrCreateClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        Integer modelHash = AmazonBedrockInferenceClient.getModelKeysAndRegionHashcode(model, timeout);
        this.cacheLock.readLock().lock();
        try {
            AmazonBedrockBaseClient amazonBedrockBaseClient = this.clientsCache.computeIfAbsent(modelHash, hashKey -> {
                AmazonBedrockBaseClient builtClient = this.creator.apply(model, timeout);
                builtClient.setClock(this.clock);
                builtClient.resetExpiration();
                return builtClient;
            });
            return amazonBedrockBaseClient;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushExpiredClients() {
        Instant currentTimestampMs = this.clock.instant();
        ArrayList<Map.Entry<Integer, AmazonBedrockBaseClient>> expiredClients = new ArrayList<Map.Entry<Integer, AmazonBedrockBaseClient>>();
        this.cacheLock.readLock().lock();
        try {
            for (Map.Entry<Integer, AmazonBedrockBaseClient> client : this.clientsCache.entrySet()) {
                if (!client.getValue().isExpired(currentTimestampMs)) continue;
                expiredClients.add(client);
            }
            if (expiredClients.isEmpty()) {
                return;
            }
            this.cacheLock.readLock().unlock();
            this.cacheLock.writeLock().lock();
            try {
                for (Map.Entry<Integer, AmazonBedrockBaseClient> client : expiredClients) {
                    AmazonBedrockBaseClient removed = this.clientsCache.remove(client.getKey());
                    if (removed == null) continue;
                    removed.close();
                }
            }
            finally {
                this.cacheLock.readLock().lock();
                this.cacheLock.writeLock().unlock();
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseCachedClients();
    }

    private void releaseCachedClients() {
        this.cacheLock.writeLock().lock();
        try {
            for (AmazonBedrockBaseClient client : this.clientsCache.values()) {
                client.close();
            }
            this.clientsCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        IdleConnectionReaper.shutdown();
    }

    int clientCount() {
        this.cacheLock.readLock().lock();
        try {
            int n = this.clientsCache.size();
            return n;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    void setClock(Clock newClock) {
        this.clock = Objects.requireNonNull(newClock);
    }
}

