/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.bedrockruntime.AmazonBedrockRuntimeAsync;
import com.amazonaws.services.bedrockruntime.AmazonBedrockRuntimeAsyncClientBuilder;
import com.amazonaws.services.bedrockruntime.model.AmazonBedrockRuntimeException;
import com.amazonaws.services.bedrockruntime.model.ConverseRequest;
import com.amazonaws.services.bedrockruntime.model.ConverseResult;
import com.amazonaws.services.bedrockruntime.model.InvokeModelRequest;
import com.amazonaws.services.bedrockruntime.model.InvokeModelResult;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Future;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;

public class AmazonBedrockInferenceClient
extends AmazonBedrockBaseClient {
    static final int CLIENT_CACHE_EXPIRY_MINUTES = 5;
    private static final int DEFAULT_CLIENT_TIMEOUT_MS = 10000;
    private final AmazonBedrockRuntimeAsync internalClient;
    private volatile Instant expiryTimestamp;

    public static AmazonBedrockBaseClient create(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        try {
            return new AmazonBedrockInferenceClient(model, timeout);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to create Amazon Bedrock Client", (Throwable)e, new Object[0]);
        }
    }

    protected AmazonBedrockInferenceClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        super(model, timeout);
        this.internalClient = this.createAmazonBedrockClient(model, timeout);
        this.setExpiryTimestamp();
    }

    @Override
    public void converse(ConverseRequest converseRequest, ActionListener<ConverseResult> responseListener) throws ElasticsearchException {
        try {
            Future responseFuture = this.internalClient.converseAsync(converseRequest);
            responseListener.onResponse((Object)((ConverseResult)responseFuture.get()));
        }
        catch (AmazonBedrockRuntimeException amazonBedrockRuntimeException) {
            responseListener.onFailure((Exception)((Object)new ElasticsearchException(Strings.format((String)"AmazonBedrock converse failure: [%s]", (Object[])new Object[]{amazonBedrockRuntimeException.getMessage()}), (Throwable)amazonBedrockRuntimeException, new Object[0])));
        }
        catch (ElasticsearchException elasticsearchException) {
            responseListener.onFailure((Exception)((Object)elasticsearchException));
        }
        catch (Exception e) {
            responseListener.onFailure((Exception)((Object)new ElasticsearchException("Amazon Bedrock client converse call failed", (Throwable)e, new Object[0])));
        }
    }

    @Override
    public void invokeModel(InvokeModelRequest invokeModelRequest, ActionListener<InvokeModelResult> responseListener) throws ElasticsearchException {
        try {
            Future responseFuture = this.internalClient.invokeModelAsync(invokeModelRequest);
            responseListener.onResponse((Object)((InvokeModelResult)responseFuture.get()));
        }
        catch (AmazonBedrockRuntimeException amazonBedrockRuntimeException) {
            responseListener.onFailure((Exception)((Object)new ElasticsearchException(Strings.format((String)"AmazonBedrock invoke model failure: [%s]", (Object[])new Object[]{amazonBedrockRuntimeException.getMessage()}), (Throwable)amazonBedrockRuntimeException, new Object[0])));
        }
        catch (ElasticsearchException elasticsearchException) {
            responseListener.onFailure((Exception)((Object)elasticsearchException));
        }
        catch (Exception e) {
            responseListener.onFailure((Exception)((Object)new ElasticsearchException((Throwable)e)));
        }
    }

    protected AmazonBedrockRuntimeAsync createAmazonBedrockClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        AmazonBedrockSecretSettings secretSettings = model.getSecretSettings();
        BasicAWSCredentials credentials = new BasicAWSCredentials(secretSettings.accessKey.toString(), secretSettings.secretKey.toString());
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        ClientConfiguration clientConfig = timeout == null ? new ClientConfiguration().withConnectionTimeout(10000) : new ClientConfiguration().withConnectionTimeout((int)timeout.millis());
        AmazonBedrockServiceSettings serviceSettings = model.getServiceSettings();
        try {
            SpecialPermission.check();
            AmazonBedrockRuntimeAsyncClientBuilder builder = AccessController.doPrivileged(() -> (AmazonBedrockRuntimeAsyncClientBuilder)((AmazonBedrockRuntimeAsyncClientBuilder)((AmazonBedrockRuntimeAsyncClientBuilder)AmazonBedrockRuntimeAsyncClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider)).withRegion(serviceSettings.region())).withClientConfiguration(clientConfig));
            return (AmazonBedrockRuntimeAsync)SocketAccess.doPrivileged(() -> ((AmazonBedrockRuntimeAsyncClientBuilder)builder).build());
        }
        catch (AmazonBedrockRuntimeException amazonBedrockRuntimeException) {
            throw new ElasticsearchException(Strings.format((String)"failed to create AmazonBedrockRuntime client: [%s]", (Object[])new Object[]{amazonBedrockRuntimeException.getMessage()}), (Throwable)amazonBedrockRuntimeException, new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to create AmazonBedrockRuntime client", (Throwable)e, new Object[0]);
        }
    }

    private void setExpiryTimestamp() {
        this.expiryTimestamp = this.clock.instant().plus(Duration.ofMinutes(5L));
    }

    @Override
    public boolean isExpired(Instant currentTimestampMs) {
        Objects.requireNonNull(currentTimestampMs);
        return currentTimestampMs.isAfter(this.expiryTimestamp);
    }

    @Override
    public void resetExpiration() {
        this.setExpiryTimestamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonBedrockInferenceClient that = (AmazonBedrockInferenceClient)o;
        return Objects.equals(this.modelKeysAndRegionHashcode, that.modelKeysAndRegionHashcode);
    }

    public int hashCode() {
        return this.modelKeysAndRegionHashcode;
    }

    @Override
    void close() {
        this.internalClient.shutdown();
    }
}

