/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockChatCompletionExecutor;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockEmbeddingsExecutor;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockExecutor;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.AmazonBedrockRequest;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.embeddings.AmazonBedrockEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.amazonbedrock.AmazonBedrockResponseHandler;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class AmazonBedrockExecuteOnlyRequestSender
implements RequestSender {
    protected final AmazonBedrockClientCache clientCache;
    private final ThrottlerManager throttleManager;

    public AmazonBedrockExecuteOnlyRequestSender(AmazonBedrockClientCache clientCache, ThrottlerManager throttlerManager) {
        this.clientCache = Objects.requireNonNull(clientCache);
        this.throttleManager = Objects.requireNonNull(throttlerManager);
    }

    @Override
    public void send(Logger logger, Request request, HttpClientContext context, Supplier<Boolean> hasRequestTimedOutFunction, ResponseHandler responseHandler, ActionListener<InferenceServiceResults> listener) {
        if (request instanceof AmazonBedrockRequest) {
            AmazonBedrockRequest awsRequest = (AmazonBedrockRequest)request;
            if (responseHandler instanceof AmazonBedrockResponseHandler) {
                AmazonBedrockResponseHandler awsResponse = (AmazonBedrockResponseHandler)responseHandler;
                try {
                    AmazonBedrockExecutor executor = this.createExecutor(awsRequest, awsResponse, logger, hasRequestTimedOutFunction, listener);
                    executor.run();
                    return;
                }
                catch (Exception e) {
                    this.logException(logger, request, e);
                    listener.onFailure(this.wrapWithElasticsearchException(e, request.getInferenceEntityId()));
                }
            }
        }
        listener.onFailure((Exception)((Object)new ElasticsearchException("Amazon Bedrock request was not the correct type", new Object[0])));
    }

    protected AmazonBedrockExecutor createExecutor(AmazonBedrockRequest awsRequest, AmazonBedrockResponseHandler awsResponse, Logger logger, Supplier<Boolean> hasRequestTimedOutFunction, ActionListener<InferenceServiceResults> listener) {
        switch (awsRequest.taskType()) {
            case COMPLETION: {
                return new AmazonBedrockChatCompletionExecutor((AmazonBedrockChatCompletionRequest)awsRequest, awsResponse, logger, hasRequestTimedOutFunction, listener, this.clientCache);
            }
            case TEXT_EMBEDDING: {
                return new AmazonBedrockEmbeddingsExecutor((AmazonBedrockEmbeddingsRequest)awsRequest, awsResponse, logger, hasRequestTimedOutFunction, listener, this.clientCache);
            }
        }
        throw new UnsupportedOperationException("Unsupported task type [" + awsRequest.taskType() + "] for Amazon Bedrock request");
    }

    private void logException(Logger logger, Request request, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttleManager.warn(logger, Strings.format((String)"Failed while sending request from inference entity id [%s] of type [amazonbedrock]", (Object[])new Object[]{request.getInferenceEntityId()}), causeException);
    }

    private Exception wrapWithElasticsearchException(Exception e, String inferenceEntityId) {
        return new ElasticsearchException(Strings.format((String)"Amazon Bedrock client failed to send request from inference entity id [%s]", (Object[])new Object[]{inferenceEntityId}), (Throwable)e, new Object[0]);
    }

    public void shutdown() throws IOException {
        this.clientCache.close();
    }
}

