/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.huggingface;

import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.huggingface.HuggingFaceResponseHandler;
import org.elasticsearch.xpack.inference.external.response.huggingface.HuggingFaceElserResponseEntity;
import org.elasticsearch.xpack.inference.external.response.huggingface.HuggingFaceEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserModel;
import org.elasticsearch.xpack.inference.services.huggingface.embeddings.HuggingFaceEmbeddingsModel;

public class HuggingFaceActionCreator
implements HuggingFaceActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public HuggingFaceActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(HuggingFaceEmbeddingsModel model) {
        HuggingFaceResponseHandler responseHandler = new HuggingFaceResponseHandler("hugging face text embeddings", HuggingFaceEmbeddingsResponseEntity::fromResponse);
        return new HuggingFaceAction(this.sender, model, this.serviceComponents, responseHandler, "text embeddings");
    }

    @Override
    public ExecutableAction create(HuggingFaceElserModel model) {
        HuggingFaceResponseHandler responseHandler = new HuggingFaceResponseHandler("hugging face elser", HuggingFaceElserResponseEntity::fromResponse);
        return new HuggingFaceAction(this.sender, model, this.serviceComponents, responseHandler, "ELSER");
    }
}

