/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.huggingface;

import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.HuggingFaceRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;

public class HuggingFaceAction
implements ExecutableAction {
    private final String errorMessage;
    private final Sender sender;
    private final HuggingFaceRequestManager requestCreator;

    public HuggingFaceAction(Sender sender, HuggingFaceModel model, ServiceComponents serviceComponents, ResponseHandler responseHandler, String requestType) {
        Objects.requireNonNull(serviceComponents);
        Objects.requireNonNull(requestType);
        this.sender = Objects.requireNonNull(sender);
        this.requestCreator = HuggingFaceRequestManager.of(model, responseHandler, serviceComponents.truncator(), serviceComponents.threadPool());
        this.errorMessage = Strings.format((String)"Failed to send Hugging Face %s request from inference entity id [%s]", (Object[])new Object[]{requestType, model.getInferenceEntityId()});
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        try {
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.errorMessage, listener);
            this.sender.send(this.requestCreator, inferenceInputs, timeout, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.errorMessage));
        }
    }
}

