/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.googleaistudio;

import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleAiStudioCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionModel;

public class GoogleAiStudioCompletionAction
implements ExecutableAction {
    private final String failedToSendRequestErrorMessage;
    private final GoogleAiStudioCompletionRequestManager requestManager;
    private final Sender sender;

    public GoogleAiStudioCompletionAction(Sender sender, GoogleAiStudioCompletionModel model, ThreadPool threadPool) {
        Objects.requireNonNull(threadPool);
        Objects.requireNonNull(model);
        this.sender = Objects.requireNonNull(sender);
        this.requestManager = new GoogleAiStudioCompletionRequestManager(model, threadPool);
        this.failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(model.uri(), "Google AI Studio completion");
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(inferenceInputs instanceof DocumentsOnlyInput)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Invalid inference input type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
        DocumentsOnlyInput docsOnlyInput = (DocumentsOnlyInput)inferenceInputs;
        if (docsOnlyInput.getInputs().size() > 1) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Google AI Studio completion only accepts 1 input", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        try {
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.failedToSendRequestErrorMessage, listener);
            this.sender.send(this.requestManager, inferenceInputs, timeout, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.failedToSendRequestErrorMessage));
        }
    }
}

