/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.googleaistudio;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googleaistudio.GoogleAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.external.action.googleaistudio.GoogleAiStudioCompletionAction;
import org.elasticsearch.xpack.inference.external.action.googleaistudio.GoogleAiStudioEmbeddingsAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionModel;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsModel;

public class GoogleAiStudioActionCreator
implements GoogleAiStudioActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public GoogleAiStudioActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(GoogleAiStudioCompletionModel model, Map<String, Object> taskSettings) {
        return new GoogleAiStudioCompletionAction(this.sender, model, this.serviceComponents.threadPool());
    }

    @Override
    public ExecutableAction create(GoogleAiStudioEmbeddingsModel model, Map<String, Object> taskSettings) {
        return new GoogleAiStudioEmbeddingsAction(this.sender, model, this.serviceComponents);
    }
}

