/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.cohere;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereActionVisitor;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereCompletionAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereEmbeddingsAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereRerankAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankModel;

public class CohereActionCreator
implements CohereActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public CohereActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(CohereEmbeddingsModel model, Map<String, Object> taskSettings, InputType inputType) {
        CohereEmbeddingsModel overriddenModel = CohereEmbeddingsModel.of(model, taskSettings, inputType);
        return new CohereEmbeddingsAction(this.sender, overriddenModel, this.serviceComponents.threadPool());
    }

    @Override
    public ExecutableAction create(CohereRerankModel model, Map<String, Object> taskSettings) {
        CohereRerankModel overriddenModel = CohereRerankModel.of(model, taskSettings);
        return new CohereRerankAction(this.sender, overriddenModel, this.serviceComponents.threadPool());
    }

    @Override
    public ExecutableAction create(CohereCompletionModel model, Map<String, Object> taskSettings) {
        return new CohereCompletionAction(this.sender, model, this.serviceComponents.threadPool());
    }
}

