/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.azureaistudio;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureaistudio.AzureAiStudioAction;
import org.elasticsearch.xpack.inference.external.action.azureaistudio.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.AzureAiStudioChatCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.AzureAiStudioEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsModel;

public class AzureAiStudioActionCreator
implements AzureAiStudioActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AzureAiStudioActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AzureAiStudioChatCompletionModel completionModel, Map<String, Object> taskSettings) {
        AzureAiStudioChatCompletionModel overriddenModel = AzureAiStudioChatCompletionModel.of(completionModel, taskSettings);
        AzureAiStudioChatCompletionRequestManager requestManager = new AzureAiStudioChatCompletionRequestManager(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(completionModel.uri(), "Azure AI Studio completion");
        return new AzureAiStudioAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(AzureAiStudioEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        AzureAiStudioEmbeddingsModel overriddenModel = AzureAiStudioEmbeddingsModel.of(embeddingsModel, taskSettings);
        AzureAiStudioEmbeddingsRequestManager requestManager = new AzureAiStudioEmbeddingsRequestManager(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(embeddingsModel.uri(), "Azure AI Studio embeddings");
        return new AzureAiStudioAction(this.sender, requestManager, errorMessage);
    }
}

