/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.amazonbedrock;

import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;

public class AmazonBedrockEmbeddingsAction
implements ExecutableAction {
    private final Sender sender;
    private final RequestManager requestManager;
    private final String errorMessage;

    public AmazonBedrockEmbeddingsAction(Sender sender, RequestManager requestManager, String errorMessage) {
        this.sender = Objects.requireNonNull(sender);
        this.requestManager = Objects.requireNonNull(requestManager);
        this.errorMessage = Objects.requireNonNull(errorMessage);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        try {
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.errorMessage, listener);
            this.sender.send(this.requestManager, inferenceInputs, timeout, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.errorMessage));
        }
    }
}

