/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;

public class Truncator {
    static final Setting<Double> REDUCTION_PERCENTAGE_SETTING = Setting.doubleSetting((String)"xpack.inference.truncator.reduction_percentage", (double)0.5, (double)0.01, (double)0.99, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final double CHARS_PER_TOKEN = 3.0;
    private volatile double reductionPercentage;

    public static List<Setting<?>> getSettings() {
        return List.of(REDUCTION_PERCENTAGE_SETTING);
    }

    public static double countTokens(String text) {
        return Math.ceil((double)text.length() / 3.0);
    }

    public Truncator(Settings settings, ClusterService clusterService) {
        this.reductionPercentage = (Double)REDUCTION_PERCENTAGE_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(REDUCTION_PERCENTAGE_SETTING, this::setReductionPercentage);
    }

    private void setReductionPercentage(double percentage) {
        this.reductionPercentage = percentage;
    }

    public static TruncationResult truncate(List<String> input, @Nullable Integer tokenLimit) {
        if (tokenLimit == null) {
            return new TruncationResult(input, new boolean[input.size()]);
        }
        int maxLength = Truncator.maxLength(tokenLimit);
        ArrayList<String> truncatedText = new ArrayList<String>(input.size());
        boolean[] wasTruncated = new boolean[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            String text = input.get(i);
            TruncationEntry truncateResult = Truncator.truncate(text, maxLength);
            truncatedText.add(truncateResult.input);
            wasTruncated[i] = truncateResult.truncated;
        }
        return new TruncationResult(truncatedText, wasTruncated);
    }

    private static int maxLength(Integer maxTokens) {
        if (maxTokens == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor((double)maxTokens.intValue() * 3.0);
    }

    private static TruncationEntry truncate(String text, int textLength) {
        String truncatedText = text.substring(0, Math.min(text.length(), textLength));
        boolean truncated = truncatedText.length() < text.length();
        return new TruncationEntry(truncatedText, truncated);
    }

    public TruncationResult truncate(List<String> input) {
        ArrayList<String> truncatedText = new ArrayList<String>(input.size());
        boolean[] wasTruncated = new boolean[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            String text = input.get(i);
            TruncationEntry truncateResult = this.truncate(text);
            truncatedText.add(truncateResult.input);
            wasTruncated[i] = truncateResult.truncated;
        }
        return new TruncationResult(truncatedText, wasTruncated);
    }

    private TruncationEntry truncate(String text) {
        int length = (int)Math.floor((double)text.length() * this.reductionPercentage);
        return Truncator.truncate(text, length);
    }

    public record TruncationResult(List<String> input, boolean[] truncated) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncationResult that = (TruncationResult)o;
            return Objects.equals(this.input, that.input) && Arrays.equals(this.truncated, that.truncated);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.input, Arrays.hashCode(this.truncated));
        }
    }

    private record TruncationEntry(String input, boolean truncated) {
    }
}

