/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceEndpointAction;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.inference.common.InferenceExceptions;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportDeleteInferenceEndpointAction
extends TransportMasterNodeAction<DeleteInferenceEndpointAction.Request, DeleteInferenceEndpointAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private static final Logger logger = LogManager.getLogger(TransportDeleteInferenceEndpointAction.class);

    @Inject
    public TransportDeleteInferenceEndpointAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:admin/xpack/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteInferenceEndpointAction.Request::new, indexNameExpressionResolver, DeleteInferenceEndpointAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
    }

    protected void masterOperation(Task task, DeleteInferenceEndpointAction.Request request, ClusterState state, ActionListener<DeleteInferenceEndpointAction.Response> masterListener) {
        SubscribableListener.newForked(modelConfigListener -> this.modelRegistry.getModel(request.getInferenceEndpointId(), (ActionListener<ModelRegistry.UnparsedModel>)modelConfigListener)).andThen((listener, unparsedModel) -> {
            if (!request.getTaskType().isAnyOrSame(unparsedModel.taskType())) {
                listener.onFailure((Exception)InferenceExceptions.mismatchedTaskTypeException(request.getTaskType(), unparsedModel.taskType()));
                return;
            }
            if (request.isDryRun()) {
                masterListener.onResponse((Object)new DeleteInferenceEndpointAction.Response(false, InferenceProcessorInfoExtractor.pipelineIdsForResource((ClusterState)state, Set.of(request.getInferenceEndpointId()))));
                return;
            }
            if (!request.isForceDelete() && TransportDeleteInferenceEndpointAction.endpointIsReferencedInPipelines(state, request.getInferenceEndpointId(), (ActionListener<Boolean>)listener)) {
                return;
            }
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isPresent()) {
                ((InferenceService)service.get()).stop(request.getInferenceEndpointId(), listener);
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException("No service found for this inference endpoint " + request.getInferenceEndpointId(), RestStatus.NOT_FOUND, new Object[0]));
            }
        }).andThen((listener, didStop) -> {
            if (didStop.booleanValue()) {
                this.modelRegistry.deleteModel(request.getInferenceEndpointId(), (ActionListener<Boolean>)listener);
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException("Failed to stop inference endpoint " + request.getInferenceEndpointId(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }).addListener(masterListener.delegateFailure((l3, didDeleteModel) -> masterListener.onResponse((Object)new DeleteInferenceEndpointAction.Response(didDeleteModel.booleanValue(), Set.of()))));
    }

    private static boolean endpointIsReferencedInPipelines(ClusterState state, String inferenceEndpointId, ActionListener<Boolean> listener) {
        Metadata metadata = state.getMetadata();
        if (metadata == null) {
            listener.onFailure((Exception)new ElasticsearchStatusException(" Could not determine if the endpoint is referenced in a pipeline as cluster state metadata was unexpectedly null. Use `force` to delete it anyway", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return true;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            logger.debug("No ingest metadata found in cluster state while attempting to delete inference endpoint");
        } else {
            Set modelIdsReferencedByPipelines = InferenceProcessorInfoExtractor.getModelIdsFromInferenceProcessors((IngestMetadata)ingestMetadata);
            if (modelIdsReferencedByPipelines.contains(inferenceEndpointId)) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Inference endpoint " + inferenceEndpointId + " is referenced by pipelines and cannot be deleted. Use `force` to delete it anyway, or use `dry_run` to list the pipelines that reference it.", RestStatus.CONFLICT, new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected ClusterBlockException checkBlock(DeleteInferenceEndpointAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }
}

