/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.ErrorChunkedInferenceResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedSparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedTextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiSecretSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalTextEmbeddingServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elser.ElserInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elser.ElserMlNodeTaskSettings;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserServiceSettings;
import org.elasticsearch.xpack.inference.services.mistral.embeddings.MistralEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class InferenceNamedWriteablesProvider {
    private InferenceNamedWriteablesProvider() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceResults.class, "text_embedding_results", LegacyTextEmbeddingResults::new));
        InferenceNamedWriteablesProvider.addInferenceResultsNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addChunkedInferenceResultsNamedWriteables(namedWriteables);
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "empty_task_settings", EmptyTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "default_secret_settings", DefaultSecretSettings::new));
        InferenceNamedWriteablesProvider.addInternalElserNamedWriteables(namedWriteables);
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "text_embedding_internal_service_settings", ElasticsearchInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "multilingual_e5_small_service_settings", MultilingualE5SmallInternalServiceSettings::new));
        InferenceNamedWriteablesProvider.addHuggingFaceNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addOpenAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addCohereNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAzureOpenAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAzureAiStudioNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addGoogleAiStudioNamedWritables(namedWriteables);
        InferenceNamedWriteablesProvider.addGoogleVertexAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addMistralNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addCustomElandWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAnthropicNamedWritables(namedWriteables);
        InferenceNamedWriteablesProvider.addAmazonBedrockNamedWriteables(namedWriteables);
        return namedWriteables;
    }

    private static void addAmazonBedrockNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(AmazonBedrockSecretSettings.class, "amazon_bedrock_secret_settings", AmazonBedrockSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "amazon_bedrock_embeddings_service_settings", AmazonBedrockEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "amazon_bedrock_chat_completion_service_settings", AmazonBedrockChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "amazon_bedrock_chat_completion_task_settings", AmazonBedrockChatCompletionTaskSettings::new));
    }

    private static void addMistralNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "mistral_embeddings_service_settings", MistralEmbeddingsServiceSettings::new));
    }

    private static void addAzureAiStudioNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_ai_studio_embeddings_service_settings", AzureAiStudioEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_ai_studio_embeddings_task_settings", AzureAiStudioEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_ai_studio_chat_completion_service_settings", AzureAiStudioChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_ai_studio_chat_completion_task_settings", AzureAiStudioChatCompletionTaskSettings::new));
    }

    private static void addAzureOpenAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(AzureOpenAiSecretSettings.class, "azure_openai_secret_settings", AzureOpenAiSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_openai_embeddings_service_settings", AzureOpenAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_openai_embeddings_task_settings", AzureOpenAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_openai_completions_service_settings", AzureOpenAiCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_openai_completion_task_settings", AzureOpenAiCompletionTaskSettings::new));
    }

    private static void addCohereNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_service_settings", CohereServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_embeddings_service_settings", CohereEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "cohere_embeddings_task_settings", CohereEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_rerank_service_settings", CohereRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "cohere_rerank_task_settings", CohereRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_completion_service_settings", CohereCompletionServiceSettings::new));
    }

    private static void addOpenAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "openai_service_settings", OpenAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "openai_embeddings_task_settings", OpenAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "openai_completion_service_settings", OpenAiChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "openai_completion_task_settings", OpenAiChatCompletionTaskSettings::new));
    }

    private static void addHuggingFaceNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_elser_service_settings", HuggingFaceElserServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_service_settings", HuggingFaceServiceSettings::new));
    }

    private static void addGoogleAiStudioNamedWritables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_ai_studio_completion_service_settings", GoogleAiStudioCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_ai_studio_embeddings_service_settings", GoogleAiStudioEmbeddingsServiceSettings::new));
    }

    private static void addGoogleVertexAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "google_vertex_ai_secret_settings", GoogleVertexAiSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_vertex_ai_embeddings_service_settings", GoogleVertexAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "google_vertex_ai_embeddings_task_settings", GoogleVertexAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_vertex_ai_rerank_service_settings", GoogleVertexAiRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "google_vertex_ai_rerank_task_settings", GoogleVertexAiRerankTaskSettings::new));
    }

    private static void addInternalElserNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elser_mlnode_service_settings", ElserInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "elser_mlnode_task_settings", ElserMlNodeTaskSettings::new));
    }

    private static void addChunkedInferenceResultsNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "error_chunked", ErrorChunkedInferenceResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "chunked_sparse_embedding_results", InferenceChunkedSparseEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "chunked_text_embedding_service_float_results", InferenceChunkedTextEmbeddingFloatResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "chunked_text_embedding_service_byte_results", InferenceChunkedTextEmbeddingByteResults::new));
    }

    private static void addInferenceResultsNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "sparse_embedding_results", SparseEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "text_embedding_service_results", InferenceTextEmbeddingFloatResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "text_embedding_service_byte_results", InferenceTextEmbeddingByteResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "chat_completion_service_results", ChatCompletionResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "rerank_service_results", RankedDocsResults::new));
    }

    private static void addCustomElandWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "custom_eland_model_internal_service_settings", CustomElandInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "custom_eland_model_internal_text_embedding_service_settings", CustomElandInternalTextEmbeddingServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "custom_eland_rerank_task_settings", CustomElandRerankTaskSettings::new));
    }

    private static void addAnthropicNamedWritables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "anthropic_completion_service_settings", AnthropicChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "anthropic_completion_task_settings", AnthropicChatCompletionTaskSettings::new));
    }
}

