/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.util;

import java.nio.ByteOrder;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.geometry.utils.WellKnownText;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpatialCoordinateTypes {
    GEO{

        @Override
        public Point longAsPoint(long encoded) {
            return new Point(GeoEncodingUtils.decodeLongitude((int)((int)encoded)), GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))));
        }

        @Override
        public long pointAsLong(double x, double y) {
            int latitudeEncoded = GeoEncodingUtils.encodeLatitude((double)y);
            int longitudeEncoded = GeoEncodingUtils.encodeLongitude((double)x);
            return (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
        }
    }
    ,
    CARTESIAN{
        private static final int MAX_VAL_ENCODED = XYEncodingUtils.encode((float)Float.MAX_VALUE);
        private static final int MIN_VAL_ENCODED = XYEncodingUtils.encode((float)-3.4028235E38f);

        @Override
        public Point longAsPoint(long encoded) {
            int x = this.checkCoordinate((int)(encoded >>> 32));
            int y = this.checkCoordinate((int)(encoded & 0xFFFFFFFFFFFFFFFFL));
            return new Point((double)XYEncodingUtils.decode((int)x), (double)XYEncodingUtils.decode((int)y));
        }

        private int checkCoordinate(int i) {
            if (i > MAX_VAL_ENCODED || i < MIN_VAL_ENCODED) {
                throw new IllegalArgumentException("Failed to convert invalid encoded value to cartesian point");
            }
            return i;
        }

        @Override
        public long pointAsLong(double x, double y) {
            long xi = XYEncodingUtils.encode((float)((float)x));
            long yi = XYEncodingUtils.encode((float)((float)y));
            return yi & 0xFFFFFFFFL | xi << 32;
        }
    }
    ,
    UNSPECIFIED{

        @Override
        public Point longAsPoint(long encoded) {
            throw new UnsupportedOperationException("Cannot convert long to point without specifying coordinate type");
        }

        @Override
        public long pointAsLong(double x, double y) {
            throw new UnsupportedOperationException("Cannot convert point to long without specifying coordinate type");
        }
    };


    public abstract Point longAsPoint(long var1);

    public abstract long pointAsLong(double var1, double var3);

    public long wkbAsLong(BytesRef wkb) {
        Point point = this.wkbAsPoint(wkb);
        return this.pointAsLong(point.getX(), point.getY());
    }

    public Point wkbAsPoint(BytesRef wkb) {
        Geometry geometry = WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return point;
        }
        throw new IllegalArgumentException("Unsupported geometry: " + geometry.type());
    }

    public BytesRef longAsWkb(long encoded) {
        return this.asWkb((Geometry)this.longAsPoint(encoded));
    }

    public String asWkt(Geometry geometry) {
        return WellKnownText.toWKT((Geometry)geometry);
    }

    public BytesRef asWkb(Geometry geometry) {
        return new BytesRef(WellKnownBinary.toWKB((Geometry)geometry, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    public BytesRef wktToWkb(String wkt) {
        try {
            Geometry geometry = WellKnownText.fromWKT((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (String)wkt);
            return new BytesRef(WellKnownBinary.toWKB((Geometry)geometry, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse WKT: " + e.getMessage(), e);
        }
    }

    public Geometry wktToGeometry(String wkt) {
        try {
            return WellKnownText.fromWKT((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (String)wkt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse WKT: " + e.getMessage(), e);
        }
    }

    public String wkbToWkt(BytesRef wkb) {
        return WellKnownText.fromWKB((byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
    }

    public Geometry wkbToGeometry(BytesRef wkb) {
        return WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
    }
}

