/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;

public class UnsupportedEsField
extends EsField {
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(EsField.class, "UnsupportedEsField", UnsupportedEsField::new);
    private final String originalType;
    private final String inherited;

    public UnsupportedEsField(String name, String originalType) {
        this(name, originalType, null, new TreeMap<String, EsField>());
    }

    public UnsupportedEsField(String name, String originalType, String inherited, Map<String, EsField> properties) {
        super(name, DataType.UNSUPPORTED, properties, false);
        this.originalType = originalType;
        this.inherited = inherited;
    }

    public UnsupportedEsField(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readOptionalString(), in.readMap(i -> (EsField)i.readNamedWriteable(EsField.class)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
        out.writeString(this.getOriginalType());
        out.writeOptionalString(this.getInherited());
        out.writeMap(this.getProperties(), StreamOutput::writeNamedWriteable);
    }

    @Override
    public String getWriteableName() {
        return UnsupportedEsField.ENTRY.name;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean hasInherited() {
        return this.inherited != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnsupportedEsField that = (UnsupportedEsField)o;
        return Objects.equals(this.originalType, that.originalType) && Objects.equals(this.inherited, that.inherited);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originalType, this.inherited);
    }
}

