/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DateEsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.TextEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;

public class EsField
implements NamedWriteable {
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(EsField.class, "EsField", EsField::new);
    private final DataType esDataType;
    private final boolean aggregatable;
    private final Map<String, EsField> properties;
    private final String name;
    private final boolean isAlias;

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(ENTRY, DateEsField.ENTRY, InvalidMappedField.ENTRY, KeywordEsField.ENTRY, TextEsField.ENTRY, UnsupportedEsField.ENTRY);
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable) {
        this(name, esDataType, properties, aggregatable, false);
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable, boolean isAlias) {
        this.name = name;
        this.esDataType = esDataType;
        this.aggregatable = aggregatable;
        this.properties = properties;
        this.isAlias = isAlias;
    }

    public EsField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.esDataType = DataType.readFrom(in);
        this.properties = in.readImmutableMap(i -> (EsField)i.readNamedWriteable(EsField.class));
        this.aggregatable = in.readBoolean();
        this.isAlias = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.esDataType.typeName());
        out.writeMap(this.properties, StreamOutput::writeNamedWriteable);
        out.writeBoolean(this.aggregatable);
        out.writeBoolean(this.isAlias);
    }

    public String getWriteableName() {
        return EsField.ENTRY.name;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.esDataType;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public Map<String, EsField> getProperties() {
        return this.properties;
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public EsField getExactField() {
        return this;
    }

    public Exact getExactInfo() {
        return Exact.EXACT_FIELD;
    }

    public String toString() {
        return this.name + "@" + this.esDataType.typeName() + "=" + this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsField field = (EsField)o;
        return this.aggregatable == field.aggregatable && this.isAlias == field.isAlias && this.esDataType == field.esDataType && Objects.equals(this.name, field.name) && Objects.equals(this.properties, field.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.esDataType, this.aggregatable, this.properties, this.name, this.isAlias});
    }

    public static final class Exact {
        private static Exact EXACT_FIELD = new Exact(true, null);
        private boolean hasExact;
        private String errorMsg;

        public Exact(boolean hasExact, String errorMsg) {
            this.hasExact = hasExact;
            this.errorMsg = errorMsg;
        }

        public boolean hasExact() {
            return this.hasExact;
        }

        public String errorMsg() {
            return this.errorMsg;
        }
    }
}

