/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public enum DataType {
    UNSUPPORTED(DataType.builder().typeName("UNSUPPORTED")),
    NULL(DataType.builder().esType("null")),
    BOOLEAN(DataType.builder().esType("boolean").size(1)),
    COUNTER_LONG(DataType.builder().esType("counter_long").size(8).docValues().counter()),
    COUNTER_INTEGER(DataType.builder().esType("counter_integer").size(4).docValues().counter()),
    COUNTER_DOUBLE(DataType.builder().esType("counter_double").size(8).docValues().counter()),
    LONG(DataType.builder().esType("long").size(8).wholeNumber().docValues().counter(COUNTER_LONG)),
    INTEGER(DataType.builder().esType("integer").size(4).wholeNumber().docValues().counter(COUNTER_INTEGER)),
    SHORT(DataType.builder().esType("short").size(2).wholeNumber().docValues().widenSmallNumeric(INTEGER)),
    BYTE(DataType.builder().esType("byte").size(1).wholeNumber().docValues().widenSmallNumeric(INTEGER)),
    UNSIGNED_LONG(DataType.builder().esType("unsigned_long").size(8).wholeNumber().docValues()),
    DOUBLE(DataType.builder().esType("double").size(8).rationalNumber().docValues().counter(COUNTER_DOUBLE)),
    FLOAT(DataType.builder().esType("float").size(4).rationalNumber().docValues().widenSmallNumeric(DOUBLE)),
    HALF_FLOAT(DataType.builder().esType("half_float").size(4).rationalNumber().docValues().widenSmallNumeric(DOUBLE)),
    SCALED_FLOAT(DataType.builder().esType("scaled_float").size(8).rationalNumber().docValues().widenSmallNumeric(DOUBLE)),
    KEYWORD(DataType.builder().esType("keyword").unknownSize().docValues()),
    TEXT(DataType.builder().esType("text").unknownSize()),
    DATETIME(DataType.builder().esType("date").typeName("DATETIME").size(8).docValues()),
    IP(DataType.builder().esType("ip").size(45).docValues()),
    VERSION(DataType.builder().esType("version").unknownSize().docValues()),
    OBJECT(DataType.builder().esType("object")),
    NESTED(DataType.builder().esType("nested")),
    SOURCE(DataType.builder().esType("_source").unknownSize()),
    DATE_PERIOD(DataType.builder().typeName("DATE_PERIOD").size(12)),
    TIME_DURATION(DataType.builder().typeName("TIME_DURATION").size(12)),
    GEO_POINT(DataType.builder().esType("geo_point").size(16).docValues()),
    CARTESIAN_POINT(DataType.builder().esType("cartesian_point").size(16).docValues()),
    CARTESIAN_SHAPE(DataType.builder().esType("cartesian_shape").unknownSize().docValues()),
    GEO_SHAPE(DataType.builder().esType("geo_shape").unknownSize().docValues()),
    DOC_DATA_TYPE(DataType.builder().esType("_doc").size(12)),
    TSID_DATA_TYPE(DataType.builder().esType("_tsid").unknownSize().docValues()),
    PARTIAL_AGG(DataType.builder().esType("partial_agg").unknownSize());

    private final String typeName;
    private final String name;
    private final String esType;
    private final int size;
    private final boolean isWholeNumber;
    private final boolean isRationalNumber;
    private final boolean docValues;
    private final boolean isCounter;
    private final DataType widenSmallNumeric;
    private final DataType counter;
    private static final Collection<DataType> TYPES;
    private static final Map<String, DataType> NAME_TO_TYPE;
    private static final Map<String, DataType> ES_TO_TYPE;
    private static final Map<String, DataType> NAME_OR_ALIAS_TO_TYPE;

    private DataType(Builder builder) {
        String typeString = builder.typeName != null ? builder.typeName : builder.esType;
        this.typeName = typeString.toLowerCase(Locale.ROOT);
        this.name = typeString.toUpperCase(Locale.ROOT);
        this.esType = builder.esType;
        this.size = builder.size;
        this.isWholeNumber = builder.isWholeNumber;
        this.isRationalNumber = builder.isRationalNumber;
        this.docValues = builder.docValues;
        this.isCounter = builder.isCounter;
        this.widenSmallNumeric = builder.widenSmallNumeric;
        this.counter = builder.counter;
    }

    public static Collection<DataType> types() {
        return TYPES;
    }

    public static DataType fromTypeName(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public static DataType fromEs(String name) {
        DataType type = ES_TO_TYPE.get(name);
        return type != null ? type : UNSUPPORTED;
    }

    public static DataType fromJava(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof Integer) {
            return INTEGER;
        }
        if (value instanceof Long) {
            return LONG;
        }
        if (value instanceof BigInteger) {
            return UNSIGNED_LONG;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof Double) {
            return DOUBLE;
        }
        if (value instanceof Float) {
            return FLOAT;
        }
        if (value instanceof Byte) {
            return BYTE;
        }
        if (value instanceof Short) {
            return SHORT;
        }
        if (value instanceof ZonedDateTime) {
            return DATETIME;
        }
        if (value instanceof String || value instanceof Character || value instanceof BytesRef) {
            return KEYWORD;
        }
        return null;
    }

    public static boolean isUnsupported(DataType from) {
        return from == UNSUPPORTED;
    }

    public static boolean isString(DataType t) {
        return t == KEYWORD || t == TEXT;
    }

    public static boolean isPrimitive(DataType t) {
        return t != OBJECT && t != NESTED && t != UNSUPPORTED;
    }

    public static boolean isNull(DataType t) {
        return t == NULL;
    }

    public static boolean isNullOrNumeric(DataType t) {
        return t.isNumeric() || DataType.isNull(t);
    }

    public static boolean isSigned(DataType t) {
        return t.isNumeric() && !t.equals((Object)UNSIGNED_LONG);
    }

    public static boolean isDateTime(DataType type) {
        return type == DATETIME;
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == NULL || right == NULL || DataType.isString(left) && DataType.isString(right) || left.isNumeric() && right.isNumeric() || DataType.isDateTime(left) && DataType.isDateTime(right);
    }

    public String nameUpper() {
        return this.name;
    }

    public String typeName() {
        return this.typeName;
    }

    public String esType() {
        return this.esType;
    }

    public String outputType() {
        return this.esType == null ? "unsupported" : this.esType;
    }

    public boolean isWholeNumber() {
        return this.isWholeNumber;
    }

    public boolean isRationalNumber() {
        return this.isRationalNumber;
    }

    public boolean isNumeric() {
        return this.isWholeNumber || this.isRationalNumber;
    }

    public int size() {
        return this.size;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public DataType widenSmallNumeric() {
        return this.widenSmallNumeric == null ? this : this.widenSmallNumeric;
    }

    public DataType counter() {
        return this.counter;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.typeName);
    }

    public static DataType readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        if (name.equalsIgnoreCase(DOC_DATA_TYPE.nameUpper())) {
            return DOC_DATA_TYPE;
        }
        DataType dataType = DataType.fromTypeName(name);
        if (dataType == null) {
            throw new IOException("Unknown DataType for type name: " + name);
        }
        return dataType;
    }

    public static Set<String> namesAndAliases() {
        return NAME_OR_ALIAS_TO_TYPE.keySet();
    }

    public static DataType fromNameOrAlias(String typeName) {
        DataType type = NAME_OR_ALIAS_TO_TYPE.get(typeName.toLowerCase(Locale.ROOT));
        return type != null ? type : UNSUPPORTED;
    }

    static Builder builder() {
        return new Builder();
    }

    static {
        TYPES = Arrays.stream(DataType.values()).filter(d -> d != DOC_DATA_TYPE && d != TSID_DATA_TYPE).sorted(Comparator.comparing(DataType::typeName)).toList();
        NAME_TO_TYPE = TYPES.stream().collect(Collectors.toUnmodifiableMap(DataType::typeName, t -> t));
        Map<String, DataType> map = TYPES.stream().filter(e -> e.esType() != null).collect(Collectors.toMap(DataType::esType, t -> t));
        map.put("point", CARTESIAN_POINT);
        map.put("shape", CARTESIAN_SHAPE);
        ES_TO_TYPE = Collections.unmodifiableMap(map);
        map = DataType.types().stream().collect(Collectors.toMap(DataType::typeName, Function.identity()));
        map.put("bool", BOOLEAN);
        map.put("int", INTEGER);
        map.put("string", KEYWORD);
        NAME_OR_ALIAS_TO_TYPE = Collections.unmodifiableMap(map);
    }

    private static class Builder {
        private String esType;
        private String typeName;
        private int size;
        private boolean isWholeNumber;
        private boolean isRationalNumber;
        private boolean docValues;
        private boolean isCounter;
        private DataType widenSmallNumeric;
        private DataType counter;

        Builder() {
        }

        Builder esType(String esType) {
            this.esType = esType;
            return this;
        }

        Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        Builder size(int size) {
            this.size = size;
            return this;
        }

        Builder unknownSize() {
            this.size = Integer.MAX_VALUE;
            return this;
        }

        Builder wholeNumber() {
            this.isWholeNumber = true;
            return this;
        }

        Builder rationalNumber() {
            this.isRationalNumber = true;
            return this;
        }

        Builder docValues() {
            this.docValues = true;
            return this;
        }

        Builder counter() {
            this.isCounter = true;
            return this;
        }

        Builder widenSmallNumeric(DataType widenSmallNumeric) {
            this.widenSmallNumeric = widenSmallNumeric;
            return this;
        }

        Builder counter(DataType counter) {
            assert (counter.isCounter);
            this.counter = counter;
            return this;
        }
    }
}

