/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.tree;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public final class Source
implements Writeable {
    public static final Source EMPTY = new Source(Location.EMPTY, "");
    private final Location location;
    private final String text;

    public Source(int line, int charPositionInLine, String text) {
        this(new Location(line, charPositionInLine), text);
    }

    public Source(Location location, String text) {
        this.location = location;
        this.text = text;
    }

    public static <S extends StreamInput> Source readFrom(S in) throws IOException {
        if (!in.readBoolean()) {
            return EMPTY;
        }
        int line = in.readInt();
        int column = in.readInt();
        int charPositionInLine = column - 1;
        int length = in.readInt();
        String text = Source.sourceText(((PlanStreamInput)in).sourceText(), line, column, length);
        return new Source(new Location(line, charPositionInLine), text);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this == EMPTY) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.location.getLineNumber());
        out.writeInt(this.location.getColumnNumber());
        out.writeInt(this.text.length());
    }

    public Location source() {
        return this.location;
    }

    public String text() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.text);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return this.text + this.location;
    }

    public static Source synthetic(String text) {
        return new Source(Location.EMPTY, text);
    }

    private static String sourceText(String query, int line, int column, int length) {
        if (line <= 0 || column <= 0 || query.isEmpty()) {
            return "";
        }
        int offset = Source.textOffset(query, line, column);
        if (offset + length > query.length()) {
            throw new QlIllegalArgumentException("location [@" + line + ":" + column + "] and length [" + length + "] overrun query size [" + query.length() + "]");
        }
        return query.substring(offset, offset + length);
    }

    private static int textOffset(String query, int line, int column) {
        int offset = 0;
        if (line > 1) {
            String[] lines = query.split("\n");
            if (line > lines.length) {
                throw new QlIllegalArgumentException("line location [" + line + "] higher than max [" + lines.length + "] in query [" + query + "]");
            }
            for (int i = 0; i < line - 1; ++i) {
                offset += lines[i].length() + 1;
            }
        }
        return offset += column - 1;
    }
}

