/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MatchQuery
extends Query {
    private static final Map<String, BiConsumer<MatchQueryBuilder, String>> BUILDER_APPLIERS = Map.ofEntries(Map.entry("analyzer", MatchQueryBuilder::analyzer), Map.entry("auto_generate_synonyms_phrase_query", (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s))), Map.entry("fuzziness", (qb, s) -> qb.fuzziness(Fuzziness.fromString((String)s))), Map.entry("fuzzy_transpositions", (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s))), Map.entry("fuzzy_rewrite", MatchQueryBuilder::fuzzyRewrite), Map.entry("lenient", (qb, s) -> qb.lenient(Booleans.parseBoolean((String)s))), Map.entry("max_expansions", (qb, s) -> qb.maxExpansions(Integer.valueOf(s).intValue())), Map.entry("minimum_should_match", MatchQueryBuilder::minimumShouldMatch), Map.entry("operator", (qb, s) -> qb.operator(Operator.fromString((String)s))), Map.entry("prefix_length", (qb, s) -> qb.prefixLength(Integer.valueOf(s).intValue())));
    private final String name;
    private final Object text;
    private final MatchQueryPredicate predicate;
    private final Map<String, String> options;

    public MatchQuery(Source source, String name, Object text) {
        this(source, name, text, null);
    }

    public MatchQuery(Source source, String name, Object text, MatchQueryPredicate predicate) {
        super(source);
        this.name = name;
        this.text = text;
        this.predicate = predicate;
        this.options = predicate == null ? Collections.emptyMap() : predicate.optionMap();
    }

    @Override
    public QueryBuilder asBuilder() {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)this.name, (Object)this.text);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public String name() {
        return this.name;
    }

    public Object text() {
        return this.text;
    }

    MatchQueryPredicate predicate() {
        return this.predicate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.text, this.name, this.predicate);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MatchQuery other = (MatchQuery)obj;
        return Objects.equals(this.text, other.text) && Objects.equals(this.name, other.name) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    protected String innerToString() {
        return this.name + ":" + this.text;
    }
}

