/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.plan.logical;

import java.util.List;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvable;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.plan.QueryPlan;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class LogicalPlan
extends QueryPlan<LogicalPlan>
implements Resolvable {
    private Stage stage = Stage.PARSED;
    private Boolean lazyChildrenResolved = null;
    private Boolean lazyResolved = null;

    public LogicalPlan(Source source, List<LogicalPlan> children) {
        super(source, children);
    }

    public boolean preAnalyzed() {
        return this.stage.ordinal() >= Stage.PRE_ANALYZED.ordinal();
    }

    public void setPreAnalyzed() {
        this.stage = Stage.PRE_ANALYZED;
    }

    public boolean analyzed() {
        return this.stage.ordinal() >= Stage.ANALYZED.ordinal();
    }

    public void setAnalyzed() {
        this.stage = Stage.ANALYZED;
    }

    public boolean optimized() {
        return this.stage.ordinal() >= Stage.OPTIMIZED.ordinal();
    }

    public void setOptimized() {
        this.stage = Stage.OPTIMIZED;
    }

    public final boolean childrenResolved() {
        if (this.lazyChildrenResolved == null) {
            this.lazyChildrenResolved = Resolvables.resolved(this.children());
        }
        return this.lazyChildrenResolved;
    }

    @Override
    public boolean resolved() {
        if (this.lazyResolved == null) {
            this.lazyResolved = this.expressionsResolved() && this.childrenResolved();
        }
        return this.lazyResolved;
    }

    public abstract boolean expressionsResolved();

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);

    public static enum Stage {
        PARSED,
        PRE_ANALYZED,
        ANALYZED,
        OPTIMIZED;

    }
}

