/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.index;

import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.index.EsIndex;
import org.elasticsearch.xpack.esql.core.index.MappingException;

public final class IndexResolution {
    private final EsIndex index;
    @Nullable
    private final String invalid;

    public static IndexResolution valid(EsIndex index) {
        Objects.requireNonNull(index, "index must not be null if it was found");
        return new IndexResolution(index, null);
    }

    public static IndexResolution invalid(String invalid) {
        Objects.requireNonNull(invalid, "invalid must not be null to signal that the index is invalid");
        return new IndexResolution(null, invalid);
    }

    public static IndexResolution notFound(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return IndexResolution.invalid("Unknown index [" + name + "]");
    }

    private IndexResolution(EsIndex index, @Nullable String invalid) {
        this.index = index;
        this.invalid = invalid;
    }

    public boolean matches(String indexName) {
        return this.isValid() && this.index.name().equals(indexName);
    }

    public EsIndex get() {
        if (this.invalid != null) {
            throw new MappingException(this.invalid, new Object[0]);
        }
        return this.index;
    }

    public boolean isValid() {
        return this.invalid == null;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndexResolution other = (IndexResolution)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.invalid, other.invalid);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.invalid);
    }

    public String toString() {
        return this.invalid != null ? this.invalid : this.index.name();
    }
}

