/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Foldables;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.StringUtils;

public class In
extends ScalarFunction {
    private final Expression value;
    private final List<Expression> list;
    private final ZoneId zoneId;

    public In(Source source, Expression value, List<Expression> list) {
        this(source, value, list, null);
    }

    public In(Source source, Expression value, List<Expression> list, ZoneId zoneId) {
        super(source, CollectionUtils.combine(list, value));
        this.value = value;
        this.list = new ArrayList<Expression>(new LinkedHashSet<Expression>(list));
        this.zoneId = zoneId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected NodeInfo<In> info() {
        return NodeInfo.create(this, In::new, this.value(), this.list(), this.zoneId());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new In(this.source(), newChildren.get(newChildren.size() - 1), newChildren.subList(0, newChildren.size() - 1), this.zoneId());
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public Expression value() {
        return this.value;
    }

    public List<Expression> list() {
        return this.list;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children()) || Expressions.foldable(this.list) && this.list().stream().allMatch(Expressions::isNull);
    }

    @Override
    public Boolean fold() {
        if (Expressions.isNull(this.value) || this.list.size() == 1 && Expressions.isNull(this.list.get(0))) {
            return null;
        }
        return In.apply(this.value.fold(), this.foldAndConvertListOfValues(this.list, this.value.dataType()));
    }

    private static Boolean apply(Object input, List<Object> values) {
        Boolean result = Boolean.FALSE;
        for (Object v : values) {
            Boolean compResult = Comparisons.eq(input, v);
            if (compResult == null) {
                result = null;
                continue;
            }
            if (compResult != Boolean.TRUE) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    @Override
    protected Expression canonicalize() {
        List<Expression> canonicalValues = Expressions.canonicalize(this.list);
        Collections.sort(canonicalValues, (l, r) -> Integer.compare(l.hashCode(), r.hashCode()));
        return new In(this.source(), this.value, canonicalValues, this.zoneId);
    }

    protected List<Object> foldAndConvertListOfValues(List<Expression> expressions, DataType dataType) {
        ArrayList<Object> values = new ArrayList<Object>(expressions.size());
        for (Expression e : expressions) {
            values.add(DataTypeConverter.convert(Foldables.valueOf(e), dataType));
        }
        return values;
    }

    protected boolean areCompatible(DataType left, DataType right) {
        return DataType.areCompatible(left, right);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isExact(this.value, this.functionName(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        for (Expression ex : this.list) {
            if (ex.foldable()) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{Expressions.name(ex), this.sourceText()}));
        }
        DataType dt = this.value.dataType();
        for (int i = 0; i < this.list.size(); ++i) {
            Expression listValue = this.list.get(i);
            if (this.areCompatible(dt, listValue.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal(i + 1), this.sourceText(), dt.typeName(), Expressions.name(listValue), listValue.dataType().typeName()}));
        }
        return super.resolveType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.list);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        In other = (In)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.list, other.list);
    }
}

