/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public class MetadataAttribute
extends TypedAttribute {
    public static final String TIMESTAMP_FIELD = "@timestamp";
    public static final String TSID_FIELD = "_tsid";
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "MetadataAttribute", MetadataAttribute::new);
    private static final Map<String, Tuple<DataType, Boolean>> ATTRIBUTES_MAP = Map.of("_version", Tuple.tuple((Object)((Object)DataType.LONG), (Object)false), "_index", Tuple.tuple((Object)((Object)DataType.KEYWORD), (Object)true), "_id", Tuple.tuple((Object)((Object)DataType.KEYWORD), (Object)false), "_ignored", Tuple.tuple((Object)((Object)DataType.KEYWORD), (Object)true), "_source", Tuple.tuple((Object)((Object)DataType.SOURCE), (Object)false));
    private final boolean searchable;

    public MetadataAttribute(Source source, String name, DataType dataType, String qualifier, Nullability nullability, NameId id, boolean synthetic, boolean searchable) {
        super(source, name, dataType, qualifier, nullability, id, synthetic);
        this.searchable = searchable;
    }

    public MetadataAttribute(Source source, String name, DataType dataType, boolean searchable) {
        this(source, name, dataType, null, Nullability.TRUE, null, false, searchable);
    }

    public MetadataAttribute(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readString(), DataType.readFrom(in), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), NameId.readFrom((StreamInput)((PlanStreamInput)in)), in.readBoolean(), in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeString(this.name());
        this.dataType().writeTo(out);
        out.writeOptionalString(this.qualifier());
        out.writeEnum((Enum)this.nullable());
        this.id().writeTo(out);
        out.writeBoolean(this.synthetic());
        out.writeBoolean(this.searchable);
    }

    public String getWriteableName() {
        return MetadataAttribute.ENTRY.name;
    }

    @Override
    protected MetadataAttribute clone(Source source, String name, DataType type, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        return new MetadataAttribute(source, name, type, qualifier, nullability, id, synthetic, this.searchable);
    }

    @Override
    protected String label() {
        return "m";
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MetadataAttribute::new, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.searchable);
    }

    public boolean searchable() {
        return this.searchable;
    }

    private MetadataAttribute withSource(Source source) {
        return new MetadataAttribute(source, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.searchable());
    }

    public static MetadataAttribute create(Source source, String name) {
        Tuple<DataType, Boolean> t = ATTRIBUTES_MAP.get(name);
        return t != null ? new MetadataAttribute(source, name, (DataType)((Object)t.v1()), (Boolean)t.v2()) : null;
    }

    public static DataType dataType(String name) {
        Tuple<DataType, Boolean> t = ATTRIBUTES_MAP.get(name);
        return t != null ? (DataType)((Object)t.v1()) : null;
    }

    public static boolean isSupported(String name) {
        return ATTRIBUTES_MAP.containsKey(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MetadataAttribute other = (MetadataAttribute)obj;
        return this.searchable == other.searchable;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.searchable);
    }
}

