/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public class FieldAttribute
extends TypedAttribute {
    public static final String SYNTHETIC_ATTRIBUTE_NAME_PREFIX = "$$";
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "FieldAttribute", FieldAttribute::new);
    private final FieldAttribute parent;
    private final String path;
    private final EsField field;

    public FieldAttribute(Source source, String name, EsField field) {
        this(source, null, name, field);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field) {
        this(source, parent, name, field, null, Nullability.TRUE, null, false);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        this(source, parent, name, field.getDataType(), field, qualifier, nullability, id, synthetic);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, DataType type, EsField field, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        super(source, name, type, qualifier, nullability, id, synthetic);
        this.path = parent != null ? parent.fieldName() : "";
        this.parent = parent;
        this.field = field;
    }

    public FieldAttribute(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (FieldAttribute)in.readOptionalWriteable(FieldAttribute::new), in.readString(), DataType.readFrom(in), (EsField)in.readNamedWriteable(EsField.class), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), NameId.readFrom((StreamInput)((PlanStreamInput)in)), in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.parent);
        out.writeString(this.name());
        this.dataType().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeOptionalString(this.qualifier());
        out.writeEnum((Enum)this.nullable());
        this.id().writeTo(out);
        out.writeBoolean(this.synthetic());
    }

    public String getWriteableName() {
        return FieldAttribute.ENTRY.name;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, FieldAttribute::new, this.parent, this.name(), this.dataType(), this.field, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public FieldAttribute parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public String fieldName() {
        if (!this.name().startsWith(SYNTHETIC_ATTRIBUTE_NAME_PREFIX)) {
            return this.name();
        }
        return Strings.hasText((String)this.path) ? this.path + "." + this.field.getName() : this.field.getName();
    }

    public String qualifiedPath() {
        return this.qualifier() != null ? this.qualifier() + (String)(Strings.hasText((String)this.path) ? "." + this.path : "") : this.path;
    }

    public EsField.Exact getExactInfo() {
        return this.field.getExactInfo();
    }

    public FieldAttribute exactAttribute() {
        EsField exactField = this.field.getExactField();
        if (!exactField.equals(this.field)) {
            return this.innerField(exactField);
        }
        return this;
    }

    private FieldAttribute innerField(EsField type) {
        return new FieldAttribute(this.source(), this, this.name() + "." + type.getName(), type, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected Attribute clone(Source source, String name, DataType type, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        FieldAttribute qualifiedParent = this.parent != null ? (FieldAttribute)this.parent.withQualifier(qualifier) : null;
        return new FieldAttribute(source, qualifiedParent, name, this.field, qualifier, nullability, id, synthetic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.field);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.path, ((FieldAttribute)obj).path) && Objects.equals(this.field, ((FieldAttribute)obj).field);
    }

    @Override
    protected String label() {
        return "f";
    }

    public EsField field() {
        return this.field;
    }
}

